# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins
import SharedMem
import Shark
import Tac
import Tracing
from Toggles import SnmpToggleLib

t0 = Tracing.trace0

class CfmSnmpPlugin:
   def __init__( self, ctx ):
      t0( 'Initializing CfmSnmpPlugin' )
      self.entityManager_ = ctx.entityManager()
      sysdb = self.entityManager_.root()
      snmpRoot = sysdb.parent[ 'snmp' ]
      cfmSnmpDir = snmpRoot.mkdir( 'cfm' )
      # pylint: disable=unused-variable
      # UNCOMMENT pylint message once mibs are being used and
      # passed to the appropriate SMs.
      dot1agCfmMib = cfmSnmpDir.newEntity( 'CfmSnmp::Dot1agCfmMib', 'dot1agCfmMib' )
      mefSoamCfmMib = cfmSnmpDir.newEntity( 'CfmSnmp::MefSoamCfmMib',
                                            'mefSoamCfmMib' )
      # IntfSnmp plugin which provides this mapping is a pre-requisite for CfmSnmp
      # plugin and is added to the "requires" list below to force the dependency.
      ifMib = snmpRoot[ 'intf' ][ 'ifmib' ]

      mg = self.entityManager_.mountGroup()
      cfmAleConfig = mg.mount( 'cfm/aleConfig', 'Cfm::AleConfig', 'r' )
      cfmAleStatus = mg.mount( 'cfm/aleStatus', 'Cfm::AleStatus', 'r' )
      # Shark mount must use mount group (no inline option like in Smash where you
      # can call shmemEm.doMount directly), and the type must be shadow, no passive
      # reader yet
      shmemEm = SharedMem.entityManager( sysdbEm=self.entityManager_ )
      shmemMg = shmemEm.getMountGroup()
      mepMiStatsHistory = shmemMg.doMount( 'cfm/mepMiStatsHistory',
                                           'CfmShark::MepMiStatsHistory',
                                           Shark.mountInfo( 'shadow' ) )

      snmpAgentRoot = sysdb.parent[ 'Snmp' ]
      scheduler = snmpAgentRoot[ 'root' ].scheduler
      self.root_ = None

      def _finishMounts():
         t0( 'CfmSnmp SnmpPlugin _finishMounts' )
         self.root_ = snmpAgentRoot.newEntity( 'CfmSnmp::Agent::Root', 'CfmSnmp' )
         self.root_.agent = ( scheduler,
                              cfmAleConfig,
                              cfmAleStatus,
                              mepMiStatsHistory,
                              dot1agCfmMib,
                              mefSoamCfmMib,
                              ifMib )

      mg.close( lambda: None )
      shmemMg.doClose()
      ctx.callbackIs( _finishMounts )

@Plugins.plugin( requires=( 'snmp/intf', ) )
def Plugin( ctx ):
   if SnmpToggleLib.toggleCfmPmMiSnmpEnabled():
      t0( 'Loading CfmSnmp plugin' )
      CfmSnmpPlugin( ctx )
