#!/usr/bin/env python3
# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins
import Tracing

# pkgdeps: import SnmpPlugin.IntfSnmp

handle = Tracing.Handle( 'ClbSnmpPlugin' )
t0 = handle.trace0

class ClbSnmpPlugin:
   def __init__( self, ctx ):
      self.em_ = ctx.entityManager()
      sysdb = self.em_.root()
      snmpRoot = sysdb.parent[ 'snmp' ]
      snmpStatus = sysdb[ 'snmp' ][ 'status' ]
      snmpAgentRoot = sysdb.parent[ 'Snmp' ]

      mibDir = snmpRoot.mkdir( 'clb' )
      clbMib = mibDir.newEntity( 'ClbSnmp::ClbMib', 'clbMib' )
      ifMib = snmpRoot[ 'intf' ][ 'ifmib' ]

      self.root_ = None

      mg = self.em_.mountGroup()

      clbConfig = mg.mount( 'clb/config', 'Clb::Config', 'r' )
      clbStatus = mg.mount( 'clb/status', 'Clb::Status', 'r' )
      clbReqs = mg.mount(
         'clb/hardware/requirements', 'Clb::Hardware::Requirements', 'r' )
      clbSnmpStatus = mg.mount( 'snmp/clb/status', 'ClbSnmp::ClbSnmpStatus', 'w' )

      mg.close( lambda: None )

      def _finishMounts():
         t0( 'ClbSnmpPlugin finish mounts' )
         self.root_ = snmpAgentRoot.newEntity( 'ClbSnmp::Root',
                                               'ClbSnmp' )
         self.root_.clbSnmpAgent = (
            clbConfig, clbStatus, clbMib, ifMib, snmpStatus, clbSnmpStatus )
         clbMib.clbStatus = clbStatus
         clbMib.clbReqs = clbReqs
         clbMib.clbConfig = clbConfig

      ctx.callbackIs( _finishMounts )

# Need IntfSnmp for ifMib which we will need to get ifIndexes
@Plugins.plugin( requires=( 'snmp/intf', ) )
def Plugin( ctx ):
   t0( 'Loading ClbSnmp plugin' )
   ClbSnmpPlugin( ctx )
