#!/usr/bin/env python3
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, Tracing

traceHandle = Tracing.Handle( 'SysMgrSnmp' )
t0 = traceHandle.trace0

class SysMgrSnmpPlugin:
   def __init__( self, ctx ):
      entityManager = ctx.entityManager()
      self.entityManager_ = entityManager
      sysdb = entityManager.root()
      snmpRoot = sysdb.parent[ 'snmp' ]
      sysMgrMibDir = snmpRoot.mkdir( 'sysMgr' )
      mib = sysMgrMibDir.newEntity( 'SysMgrSnmp::ConfigCopyMib', 'configCopyMIB' )
      mg = entityManager.mountGroup()

      self.root_ = None

      def _finishMounts():
         idx = Tac.newInstance( 'SysMgrSnmp::ConfigCopyTableIndex', 'default', 0 )
         mib.configCopyCommandTable.newMember( mib, idx )
      mg.close( lambda: None )
      ctx.callbackIs( _finishMounts )

def Plugin( ctx ):
   t0( "SysMgrMib plugin loading..." )
   SysMgrSnmpPlugin( ctx )
   Tac.dlopen( "libSysMgrSnmp.so" )
