#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins
import Tac
from SnmpPlugin.XcvrAllStatusDir import xcvrAllStatusDirSysdbPath

class DenaliSnmpPlugin:
   def __init__( self, ctx ):
      entityManager = ctx.entityManager()
      self.entityManager_ = entityManager
      sysdb = entityManager.root()

      mg = entityManager.mountGroup()

      phyChipStatus = mg.mount( 'hardware/phyChip/status/ac400',
                                'Tac::Dir', "ri" )
      phyChipConfig = mg.mount( 'hardware/phyChip/config/ac400',
                                'Tac::Dir', "ri" )

      snmpAgentRoot = sysdb.parent[ 'Snmp' ]
      fruSnmpSensors = snmpAgentRoot[ 'FruSnmpSensors' ]
      xcvrAllStatusDir = snmpAgentRoot[ 'XcvrAllNewStatusDir' ]
      self.root_ = None

      def _finishMounts():
         self.root_ = snmpAgentRoot.newEntity( 'DenaliSnmp::Agent::Root',
                                               'DenaliSnmp' )
         self.root_.agent = ( phyChipConfig, phyChipStatus, fruSnmpSensors,
                              xcvrAllStatusDir )

      mg.close( lambda: None )
      ctx.callbackIs( _finishMounts )

@Plugins.plugin( requires=( 'Snmp/FruSnmpSensors', xcvrAllStatusDirSysdbPath ) )
def Plugin( ctx ):
   DenaliSnmpPlugin( ctx )
