# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins
import Tac
import Tracing

handle = Tracing.Handle( 'PtpSnmp' )
t0 = handle.trace0

class PtpSnmpPlugin:
   def __init__( self, ctx ):
      entityManager = ctx.entityManager()
      self.entityManager_ = entityManager
      sysdb = entityManager.root()
      snmpRoot = sysdb.parent[ 'snmp' ]
      ptpRoot = snmpRoot.mkdir( 'ptp' )
      ptpMib = ptpRoot.newEntity( 'PtpSnmp::PtpMib', 'ptpmib' )
      ifMib = snmpRoot[ 'intf' ][ 'ifmib' ]

      mg = entityManager.mountGroup()
      ptpStatus = mg.mount( "ptp/status", "Ptp::Status", "r" )

      ptpAgentRoot = sysdb.parent[ 'Snmp' ]
      self.root_ = None

      def _finishMounts():
         self.root_ = ptpAgentRoot.newEntity( 'PtpSnmp::Agent::Root', 'PtpSnmp' )
         self.root_.agent = ( ptpStatus, ptpMib, ifMib )

      mg.close( lambda: None )
      ctx.callbackIs( _finishMounts )

@Plugins.plugin( requires=( 'snmp/intf', ) )
def Plugin( ctx ):
   t0( 'Loading PtpSnmp plugin' )
   PtpSnmpPlugin( ctx )
