# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins
import Tac
import Tracing

# pkgdeps: import SnmpPlugin.IntfSnmp

handle = Tracing.Handle( 'StormControlSnmpPlugin' )
t0 = handle.trace0

class StormControlSnmpPlugin:
   def __init__( self, ctx ):
      self.em_ = ctx.entityManager()

      sysdb = self.em_.root()
      snmpRoot = sysdb.parent[ 'snmp' ]
      mibDir = snmpRoot.mkdir( 'stormcontrol' )
      mib = mibDir.newEntity( 'StormControlSnmp::StormControlMib',
                              'stormcontrolmib' )
      ifMib = snmpRoot[ 'intf' ][ 'ifmib' ]

      snmpAgentRoot = sysdb.parent[ 'Snmp' ]
      self.root_ = None

      mg = self.em_.mountGroup()
      intfSlice = mg.mount( 'bridging/stormcontrol/status/slice', 'Tac::Dir', 'ri' )

      def _finishMounts():
         t0( 'StormControlSnmpPlugin finish mounts' )

         self.root_ = snmpAgentRoot.newEntity( 'StormControlSnmp::Root',
                                               'StormControlSnmp' )
         self.root_.stormControlSnmpAgent = ( mib, intfSlice, ifMib )

      mg.close( lambda: None )
      ctx.callbackIs( _finishMounts )

# Need IntfSnmp for ifMib which we will need to get ifIndexes
@Plugins.plugin( requires=( 'snmp/intf', ) )
def Plugin( ctx ):
   t0( 'Loading StormControlSnmp plugin' )
   StormControlSnmpPlugin( ctx )
