# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# it's better to keep the changes related to
# the system group separate from the file: Snmp/Snmp.py.

import Tac
import Tracing

traceHandle = Tracing.Handle( 'Snmp' )
t0 = traceHandle.trace0

def Plugin( ctx ):
   t0( "SystemGroup plugin loading..." )
   entityManager = ctx.entityManager()
   Tac.dlopen( "libSnmpSystemGroup.so" )
   systemGroup = entityManager.root().parent[ 'snmp' ].\
         newEntity( 'Snmp::SnmpSystemGroup', 'systemGroup' )
   mg = entityManager.mountGroup()

   mg.mount( "snmp/config", "Snmp::Config", "w" )
   netConfig = mg.mount( "sys/net/config", "System::NetConfig", "w" )

   def _finishMounts():
      systemGroup.systemNetConfig = netConfig

   mg.close( lambda: None )
   ctx.callbackIs( _finishMounts )
