# Copyright (c) 2010-2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import Tracing

traceHandle = Tracing.Handle( 'Snmp' )
t0 = traceHandle.trace0

class TestMibSnmpPlugin:
   def __init__( self, ctx ):
      entityManager = ctx.entityManager()
      sysdb = entityManager.root()
      snmpRoot = sysdb.parent[ 'Snmp' ]

      def _finishMounts():
         root_ = snmpRoot.newEntity( 'Snmp::TestMibRoot',
                                       'aristaTestMib' )
         root_.testMibSm = ( aristaTestMib, )

      mg = entityManager.mountGroup()
      aristaTestMib = mg.mount( "snmp/testMib", "Snmp::TestMib", "r" )
      mg.close( lambda: None )
      ctx.callbackIs( _finishMounts )

def Plugin( ctx ):
   t0( "Snmp plugin loading..." )
   TestMibSnmpPlugin( ctx )
