# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins
import Tracing

# pkgdeps: import SnmpPlugin.IntfSnmp

handle = Tracing.Handle( 'TunnelIntfSnmpPlugin' )
t0 = handle.trace0

class TunnelIntfSnmpPlugin:
   def __init__( self, ctx ):
      self.em_ = ctx.entityManager()
      sysdb = self.em_.root()
      snmpRoot = sysdb.parent[ 'snmp' ]
      mibDir = snmpRoot.mkdir( 'tunnelIntf' )
      mib = mibDir.newEntity( 'TunnelIntfSnmp::TunnelMib', 'tunnelMib' )
      ifMib = snmpRoot[ 'intf' ][ 'ifmib' ]

      snmpAgentRoot = sysdb.parent[ 'Snmp' ]
      self.root_ = None

      mg = self.em_.mountGroup()
      intfStatusDir = mg.mount( 'interface/status/tunnel/intf',
            'Interface::TunnelIntfStatusDir', 'r' )
      ikeStatus = mg.mount( 'ipsec/ike/status', 'Ipsec::Ike::Status', 'r' )

      def _finishMounts():
         t0( 'TunnelIntfSnmpPlugin finish mounts' )
         self.root_ = snmpAgentRoot.newEntity( 'TunnelIntfSnmp::Root',
                                               'TunnelIntfSnmp' )
         self.root_.tunnelIntfSnmpAgent = ( mib, intfStatusDir, ifMib, ikeStatus )

      mg.close( lambda: None )
      ctx.callbackIs( _finishMounts )

# Need IntfSnmp for ifMib which we will need to get ifIndexes
@Plugins.plugin( requires=( 'snmp/intf', ) )
def Plugin( ctx ):
   t0( 'Loading TunnelIntfSnmp plugin' )
   TunnelIntfSnmpPlugin( ctx )
