# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins
import Tracing

handle = Tracing.Handle( 'VxlanSnmp' )
t0 = handle.trace0

class VxlanSnmpPlugin:
   def __init__( self, ctx ):
      entityManager = ctx.entityManager()
      self.entityManager_ = entityManager
      sysdb = entityManager.root()
      snmpRoot = sysdb.parent[ 'snmp' ]
      vxlanRoot = snmpRoot.mkdir( 'vxlan' )
      vxlanRoot.newEntity( 'VxlanSnmp::VxlanMib', 'vxlanmib' )

@Plugins.plugin( provides=( 'snmp/vxlan', ) )
def Plugin( ctx ):
   t0( 'Loading VxlanSnmp plugin' )
   VxlanSnmpPlugin( ctx )
