# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable-msg=W0612
# pylint: disable-msg=W0201

import Plugins
import Tracing
import Tac
import XcvrMountHelper

traceHandle = Tracing.Handle( 'XcvrAllStatusDir' )
t0 = traceHandle.trace0

xcvrAllStatusDirSysdbPath = 'Snmp/XcvrAllNewStatusDir'

class XcvrAllStatusDirPlugin:
   def __init__( self, ctx ):
      entityManager = ctx.entityManager()
      t0( "Running init of XcvrAllStatusDir" )
      mg = entityManager.mountGroup()

      # Mounts needed to simulate AllStatusDir
      xcvrSliceStatusDir = XcvrMountHelper.mountXcvrStatus(
            mg, 'hardware/archer/xcvr/status/slice', 'Tac::Dir', 'ri' )
      xcvrFixedStatusDir = XcvrMountHelper.mountXcvrStatus(
            mg, 'hardware/archer/xcvr/status/all', 'Tac::Dir', 'ri' )
      xcvrBaseConfigDir = mg.mount(
            'hardware/xcvr/config', 'Tac::Dir', 'ri' )
      xcvrFixedConfigDir = mg.mount(
            'hardware/xcvr/config/all', 'Xcvr::AllConfigDir', 'r' )
      xcvrSliceAgentStatusDir = mg.mount(
            'hardware/archer/xcvr/agent/status/slice', 'Tac::Dir', 'ri' )
      xcvrFixedAgentStatus = mg.mount(
            'hardware/archer/xcvr/agent/status/fixed', 'Xcvr::XcvrSliceStatus', 'r' )

      sysdb = entityManager.root()
      snmpAgentRoot = sysdb.parent[ 'Snmp' ]
      xcvrAllStatusDir = snmpAgentRoot.newEntity( 'Xcvr::AllNewStatusDir',
                                                   'XcvrAllNewStatusDir' )

      def _finishMounts():
         self.xcvrAllStatusDirSm_ = Tac.newInstance( 'Xcvr::AllStatusDirSm',
               xcvrSliceStatusDir, xcvrFixedStatusDir, xcvrBaseConfigDir,
               xcvrFixedConfigDir, xcvrSliceAgentStatusDir, xcvrFixedAgentStatus,
               xcvrAllStatusDir )

      mg.close( lambda: None )
      ctx.callbackIs( _finishMounts )

plugin = None

@Plugins.plugin( provides=( xcvrAllStatusDirSysdbPath, ) )
def Plugin( ctx ):
   t0( "XcvrAllStatusDir plugin loading..." )
   global plugin
   plugin = XcvrAllStatusDirPlugin( ctx )
