# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins
import Tac
from SnmpPlugin.XcvrAllStatusDir import xcvrAllStatusDirSysdbPath

class XcvrSnmpPlugin:
   def __init__( self, ctx ):
      entityManager = ctx.entityManager()
      self.entityManager_ = entityManager
      sysdb = entityManager.root()
      snmpRoot = sysdb.parent[ 'snmp' ]
      xcvrRoot = snmpRoot.mkdir( 'xcvr' )
      xcvrDwdmMib = xcvrRoot.newEntity( 'XcvrSnmp::XcvrDwdmMib', 'xcvrmib' )

      ifMib = snmpRoot[ 'intf' ][ 'ifmib' ]

      mg = entityManager.mountGroup()

      xcvrFixedConfigDir = mg.mount(
         'hardware/xcvr/config/all', 'Xcvr::AllConfigDir', 'r' )
      xcvrAllConfigDir = xcvrFixedConfigDir

      xcvrGlobalConfig = mg.mount( 'hardware/xcvr/xgc', 'Xcvr::Xgc', 'w' )
      coherentStatus = mg.mount( 'hardware/phy/status/data/coherent',
                                 'Tac::Dir', 'ri' )

      snmpAgentRoot = sysdb.parent[ 'Snmp' ]
      fruSnmpSensors = snmpAgentRoot[ 'FruSnmpSensors' ]
      xcvrAllStatusDir = snmpAgentRoot[ 'XcvrAllNewStatusDir' ]
      self.root_ = None

      def _finishMounts():
         self.root_ = snmpAgentRoot.newEntity( 'XcvrSnmp::Agent::Root',
                                'XcvrSnmp' )
         self.root_.agent = ( xcvrAllStatusDir, xcvrAllConfigDir, coherentStatus,
                              xcvrGlobalConfig, ifMib,fruSnmpSensors, xcvrDwdmMib )

      mg.close( lambda: None )
      ctx.callbackIs( _finishMounts )

@Plugins.plugin( requires=( 'snmp/intf', 'Snmp/FruSnmpSensors',
                            xcvrAllStatusDirSysdbPath ) )
def Plugin( ctx ):
   XcvrSnmpPlugin( ctx )
