# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

CIPHERS = {
   "3des-cbc": "Triple DES (112 bit)",
   "aes128-cbc": "Advanced Encryption Standard (128 bit, CBC mode)",
   "aes192-cbc": "Advanced Encryption Standard (192 bit, CBC mode)",
   "aes256-cbc": "Advanced Encryption Standard (256 bit, CBC mode)",
   "aes128-ctr": "Advanced Encryption Standard (128 bit, counter mode)",
   "aes192-ctr": "Advanced Encryption Standard (192 bit, counter mode)",
   "aes256-ctr": "Advanced Encryption Standard (256 bit, counter mode)",
   "arcfour": "Arcfour stream cipher (RC4 like)",
   "arcfour128": "Arcfour stream cipher (RFC 4345, 128 bit)",
   "arcfour256": "Arcfour stream cipher (RFC 4345, 256 bit)",
   "blowfish-cbc": "Blowfish block cipher (128 bit, CBC mode)",
   "cast128-cbc": "CAST-128 (RFC 2144, 128 bit, CBC mode)",
   "aes128-gcm@openssh.com":
      "Advanced Encryption Standard (128 bit, Galois/Counter mode )",
   "aes256-gcm@openssh.com":
      "Advanced Encryption Standard (256 bit, Galois/Counter mode )",
   "chacha20-poly1305@openssh.com":
      "ChaCha20 stream cipher and Poly1305 authenticator",
}
SUPPORTED_CIPHERS = [
   "3des-cbc", "aes128-cbc", "aes192-cbc", "aes256-cbc",
   "aes128-ctr", "aes192-ctr", "aes256-ctr",
   "aes128-gcm@openssh.com", "aes256-gcm@openssh.com",
   "chacha20-poly1305@openssh.com",
]
FIPS_CIPHERS = [
    "aes128-ctr", "aes192-ctr", "aes256-ctr",
    "aes128-cbc", "aes192-cbc", "aes256-cbc",
    "aes128-gcm@openssh.com", "aes256-gcm@openssh.com",
]

MACS = {
   "hmac-sha1": "Hash Message Authentication Code SHA-1",
   "hmac-sha1-96":
      "Hash Message Authentication Code SHA-1 for use in ESP and AH",
   "hmac-sha2-256": "Hash Message Authentication Code SHA2-256",
   "hmac-sha2-512": "Hash Message Authentication Code SHA2-512",
   "hmac-md5": "Hash Message Authentication Code MD5",
   "hmac-md5-96": "Hash Message Authentication Code MD5 for use in ESP and AH",
   "umac-64@openssh.com": "Hash Message Authentication Code UMAC-64",
   "umac-128@openssh.com": "Hash Message Authentication Code UMAC-128",
   "hmac-sha1-etm@openssh.com": "Encrypt-Then-Mac HMAC SHA1",
   "hmac-sha1-96-etm@openssh.com": "Encrypt-Then-Mac HMAC SHA1-96",
   "hmac-sha2-256-etm@openssh.com": "Encrypt-Then-Mac HMAC SHA2-256",
   "hmac-sha2-512-etm@openssh.com": "Encrypt-Then-Mac HMAC SHA2-512",
   "hmac-md5-etm@openssh.com": "Encrypt-Then-Mac HMAC MD5",
   "hmac-md5-96-etm@openssh.com": "Encrypt-Then-Mac HMAC MD5-96",
   "umac-64-etm@openssh.com": "Encrypt-Then-Mac HMAC UMAC-64",
   "umac-128-etm@openssh.com": "Encrypt-Then-Mac HMAC UMAC-128",
   "hmac-ripemd160": "Hash Message Authentication Code RIPEMD-160",
}
SUPPORTED_MACS = [
   "hmac-sha1",
   "hmac-sha2-256", "hmac-sha2-512",
   "hmac-md5",
   "umac-128@openssh.com",
   "hmac-sha1-etm@openssh.com",
   "hmac-sha2-256-etm@openssh.com", "hmac-sha2-512-etm@openssh.com",
   "hmac-md5-etm@openssh.com",
   "umac-128-etm@openssh.com",
]
FIPS_MACS = [
   "hmac-sha1", "hmac-sha2-256", "hmac-sha2-512",
   "hmac-sha2-256-etm@openssh.com", "hmac-sha2-512-etm@openssh.com",
]

KEXS = {
   "diffie-hellman-group1-sha1": "Oakley Group 2 with SHA-1", # group 2, RFC4253
   "diffie-hellman-group14-sha1": "Oakley Group 14 with SHA-1",
   "diffie-hellman-group14-sha256": "Oakley Group 14 with SHA-256",
   "diffie-hellman-group16-sha512": "Oakley Group 16 with SHA-512",
   "diffie-hellman-group18-sha512": "Oakley Group 18 with SHA-512",
   "diffie-hellman-group-exchange-sha1":
      "Negotiated Group Exchange with SHA-1",
   "diffie-hellman-group-exchange-sha256":
      "Negotiated Group Exchange with SHA-256",
   "ecdh-sha2-nistp256": "Elliptic Curve NIST P256",
   "ecdh-sha2-nistp384": "Elliptic Curve NIST P384",
   "ecdh-sha2-nistp521": "Elliptic Curve NIST P521",
   "curve25519-sha256": "Elliptic Curve 255519 with SHA-256",
   "curve25519-sha256@libssh.org": "Elliptic Curve 255519 with SHA-256",
   "sntrup761x25519-sha512@openssh.com":
      "Hybrid Streamlined NTRU Prime sntrup761 and X25519 with SHA-512",
   "gss-gex-sha1-": "Generic Security Service DH with SHA-1",
   "gss-group1-sha1-":
      "Generic Security Service DH using Oakley Group 2 with SHA-1",
   "gss-group14-sha1-":
      "Generic Security Service DH using Oakley Group 14 with SHA-1",
   "gss-group14-sha256-":
      "Generic Security Service DH using Oakley Group 14 with SHA-256",
   "gss-group16-sha512-":
      "Generic Security Service DH using Oakley Group 16 with SHA-512",
   "gss-nistp256-sha256-":
      "Generic Security Service ECDH over NIST P256 with SHA-256",
   "gss-curve25519-sha256-":
      "Generic Security Service ECDH over Curve25519 with SHA-256",
}
SUPPORTED_KEXS = [
   "diffie-hellman-group1-sha1",
   "diffie-hellman-group14-sha1", "diffie-hellman-group14-sha256",
   "diffie-hellman-group16-sha512", "diffie-hellman-group18-sha512",
   "diffie-hellman-group-exchange-sha1", "diffie-hellman-group-exchange-sha256",
   "ecdh-sha2-nistp256", "ecdh-sha2-nistp384", "ecdh-sha2-nistp521",
   "curve25519-sha256", "curve25519-sha256@libssh.org",
]
FIPS_KEXS = [
   "diffie-hellman-group14-sha1",
   "diffie-hellman-group14-sha256",
   "diffie-hellman-group16-sha512",
   "diffie-hellman-group18-sha512",
   "ecdh-sha2-nistp256",
   "ecdh-sha2-nistp384",
   "ecdh-sha2-nistp521",
]

HOSTKEYS = {
   "rsa": "RSA Encryption Algorithm",
   "dsa": "Digital Signature Algorithm",
   "ed25519": "Edwards-curve Digital Signature Algorithm 25519",
   "ecdsa-nistp256": "Elliptic Curve Digital Signature Algorithm NIST-P256",
   "ecdsa-nistp384": "Elliptic Curve Digital Signature Algorithm NIST-P384",
   "ecdsa-nistp521": "Elliptic Curve Digital Signature Algorithm NIST-P521",
}
SUPPORTED_HOSTKEYS = [
   "rsa",
   "dsa",
   "ed25519",
   "ecdsa-nistp256",
   "ecdsa-nistp521",
]
FIPS_HOSTKEYS = [
   "rsa",
   "ecdsa-nistp256",
   "ecdsa-nistp521",
]
HOSTKEYS_MAPPINGS = {
    "rsa": "ssh-rsa",
    "dsa": "ssh-dss",
    "ed25519": "ssh-ed25519",
    "ecdsa-nistp256": "ecdsa-sha2-nistp256",
    "ecdsa-nistp521": "ecdsa-sha2-nistp521",
}
