# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# BUG 968339 remove this graph when not needed

import Tac
import StageSysdbHelper
import Tracing
from Toggles.StageMgrToggleLib import (
      toggleStrataIgmpSnoopingAsuEnabled,
      toggleStrataTileSsuEnabled )

traceHandle = Tracing.Handle( 'StageGraphs' )
t0 = traceHandle.trace0

def registerAsuHitlessBootCharm( entityManager ):
   sh = StageSysdbHelper.StageHelper( entityManager, 'boot' )
   sh.applicationIs( "Asu Hitless boot" )
   sh.stageTimeoutIsFatalIs( True )

   sh.registerStageDependency( "CriticalAgent", [] )
   sh.registerStage( "Aaa", "CriticalAgent", complete=True )
   sh.registerStage( "SuperServer", "CriticalAgent", complete=True )
   sh.registerStage( "FastClidHelper-Cli", "CriticalAgent", complete=True )
   sh.registerStage( "CleanConfigAgent", "CriticalAgent", complete=True )
   sh.registerStage( "PhyEthtool", "CriticalAgent", complete=True )
   # MaintenanceMode is started to set qualPath for Rib/ArBgp
   sh.registerStage( "MaintenanceMode", "CriticalAgent", complete=True )

   # Adding 'InfrastructureAgent' stage before NetworkAgent stage. As of now
   # Ira is the only participating agent. This is required as Ira agent needs to
   # set the qualpath as to whether which routing agents are to run
   sh.registerStageDependency( "InfrastructureAgent", [] )
   sh.registerStage( "Ira", "InfrastructureAgent", timeout=60 )

   sh.registerStageDependency( "NetworkAgent", [ 'InfrastructureAgent' ] )
   sh.registerStage( "StpTopology", "NetworkAgent", complete=True )
   sh.registerStage( "TopoAgent", "NetworkAgent", complete=True )
   sh.registerStage( "Arp", "NetworkAgent", complete=True )
   sh.registerStage( "Acl", "NetworkAgent", complete=True )
   sh.registerStage( "PortSec", "NetworkAgent", complete=True )
   sh.registerStage( "KernelMfib", "NetworkAgent", complete=True )
   sh.registerStage( "KernelMfib6", "NetworkAgent", complete=True )
   sh.registerStage( "BessMgr", "NetworkAgent", complete=True )
   sh.registerStage( "KernelFib", "NetworkAgent", complete=True )
   sh.registerStage( "KernelNetworkInfo", "NetworkAgent", complete=True )
   sh.registerStage( "Lag", "NetworkAgent" )
   sh.registerStage( "Rib", "NetworkAgent", timeout=120 )
   sh.registerStage( "Rib-vrf", "NetworkAgent", timeout=120 )
   sh.registerStage( "Ospf", "NetworkAgent", timeout=120 )
   sh.registerStage( "Ospf-vrf", "NetworkAgent", timeout=120 )
   sh.registerStage( "Ospf3", "NetworkAgent", timeout=120 )
   sh.registerStage( "Ospf3-vrf", "NetworkAgent", timeout=120 )
   sh.registerStage( "Isis", "NetworkAgent", timeout=120 )
   sh.registerStage( "Isis-vrf", "NetworkAgent", timeout=120 )
   sh.registerStage( "IpRib", "NetworkAgent", timeout=120 )
   sh.registerStage( "ConnectedRoute", "NetworkAgent", timeout=120 )
   sh.registerStage( "RouteInput", "NetworkAgent", timeout=120 )
   sh.registerStage( "Bgp", "NetworkAgent", timeout=120 )
   sh.registerStage( "Ipv6RouterAdvt", "NetworkAgent", complete=True )
   sh.registerStage( "Pim", "NetworkAgent", complete=True )
   sh.registerStage( "Pim6", "NetworkAgent", complete=True )
   sh.registerStage( "Pimsm", "NetworkAgent", complete=True )
   sh.registerStage( "Pimsm6", "NetworkAgent", complete=True )
   sh.registerStage( "PimReg", "NetworkAgent", complete=True )
   sh.registerStage( "PimReg6", "NetworkAgent", complete=True )
   sh.registerStage( "PimBsr", "NetworkAgent", complete=True )
   sh.registerStage( "PimBsr6", "NetworkAgent", complete=True )
   sh.registerStage( "PimBidir", "NetworkAgent", complete=True )
   sh.registerStage( "PimBidirDf", "NetworkAgent", complete=True )
   sh.registerStage( "Igmp", "NetworkAgent", complete=True )
   sh.registerStage( "Mld", "NetworkAgent", complete=True )
   sh.registerStage( "Msdp", "NetworkAgent", complete=True )
   sh.registerStage( "Msdp6", "NetworkAgent", complete=True )
   sh.registerStage( "McastCommon", "NetworkAgent", complete=True )
   sh.registerStage( "McastCommon6", "NetworkAgent", complete=True )
   sh.registerStage( "IgmpSnooping", "NetworkAgent", complete=True )
   sh.registerStage( "MldSnooping", "NetworkAgent", complete=True )
   sh.registerStage( "DhcpRelay", "NetworkAgent", complete=True )
   sh.registerStage( "Fhrp", "NetworkAgent", complete=True )

   sh.registerStageDependency( "Fru-Plugins", [] )
   sh.registerStage( "Fru", "Fru-Plugins", timeout=60 )

   # Olive startup depends on Fru-Plugins to be consistent with the Switchover stage
   # graph.

   sh.registerStageDependency( "PrimaryAgent", [ "Fru-Plugins" ] )
   sh.registerStage( "ReloadCauseAgent", "PrimaryAgent", complete=True )
   sh.registerStage( "PlutoSmbus", "PrimaryAgent", complete=True )
   sh.registerStage( "PLSmbusMediator", "PrimaryAgent", complete=True )
   sh.registerStage( "PLSystem", "PrimaryAgent" )
   sh.registerStage( "PciBus", "PrimaryAgent", timeout=300 )

   sh.registerStageDependency( "HardwareAgent", [ "PrimaryAgent" ] )
 
   # On modular systems, Fru plugins need to be loaded and all of the cards
   # detected before cards can start to become FruReady. Because of this,
   # Fru-Ready needs to wait on Fru-Plugins, PrimaryAgent, and HardwareAgent.
   sh.registerStageDependency( "Fru-Ready",
         [ "Fru-Plugins", "PrimaryAgent", "HardwareAgent" ] )
   sh.registerStage( "Fru", "Fru-Ready", timeout=60 )

   # L1TopologyResolution waits until all cards are ready via Fru-Ready, and retores
   # mappings for the ready cards before proceeding with StrataCentral.
   sh.registerStageDependency( "L1TopologyResolution", [ "Fru-Ready" ] )
   sh.registerStage( "Fru", "L1TopologyResolution", timeout=10 )
   sh.registerStage( "L1PolicyAgent", "L1TopologyResolution", complete=True )
   sh.registerStageDependency( "LaunchConfigUpdate", [ "L1TopologyResolution" ] )
   sh.registerStage( "StrataCentral", "LaunchConfigUpdate", timeout=60 )
   
   if toggleStrataTileSsuEnabled():
      sh.registerStageDependency( "UftInitialization", [ "LaunchConfigUpdate" ] )
      sh.registerStage( "StrataTile", "UftInitialization", timeout=60,
            completeNotRunnable=True )

   # Dynamic registration for slicified hardware agents.
   sh.registerStageDependency( "SliceHardwareAgent", [ "HardwareAgent" ] )

   sh.registerStageDependency( "LagIntfStatusReady", [ "LaunchConfigUpdate" ] )
   sh.registerStage( "Lag", "LagIntfStatusReady", timeout=30 )

   if toggleStrataTileSsuEnabled():
      sh.registerStageDependency( "FeatureAgent", [ "UftInitialization" ] )
   else:
      sh.registerStageDependency( "FeatureAgent", [ "LaunchConfigUpdate" ] )
   sh.registerStage( "StrataL2", "FeatureAgent" )
   sh.registerStage( "StrataL2Combo", "FeatureAgent", timeout=300,
                     completeNotRunnable=True )
   sh.registerStage( "StrataL3", "FeatureAgent" )
   sh.registerStage( "StrataLag", "FeatureAgent" )
   sh.registerStage( "StrataVlanTopo", "FeatureAgent", timeout=300 )
   sh.registerStage( "StrataMirror", "FeatureAgent" )
   # StrataMmu does not run on all Strata platforms, so allow StageMgr to
   # auto-complete the stage if StrataMmu is not present
   sh.registerStage( "StrataMmu", "FeatureAgent", completeNotRunnable=True )
   sh.registerStage( "StrataTcam", "FeatureAgent" )
   sh.registerStage( "StrataQosV2", "FeatureAgent", completeNotRunnable=True )
   sh.registerStage( "StrataSec", "FeatureAgent", completeNotRunnable=True )

   sh.registerStageDependency( "XcvrWarm", [ "SliceHardwareAgent" ] )
   sh.registerStage( "B52", "XcvrWarm", complete=True )
   sh.registerStage( "Babbage", "XcvrWarm", complete=True )
   sh.registerStage( "PhyIsland", "XcvrWarm", complete=True )

   sh.registerStageDependency( "SecondaryHardwareAgent",
                               [ "XcvrWarm", "LaunchConfigUpdate", "PrimaryAgent" ] )
   sh.registerStage( "Strata", "SecondaryHardwareAgent", complete=True,
                     timeout=120 )

   sh.registerStageDependency( "ErrdisableStatusUpdate", [ "SecondaryHardwareAgent",
                                                           "LagIntfStatusReady" ] )
   sh.registerStage( "Ebra", "ErrdisableStatusUpdate", timeout=60 )

   # Qos should be dependent on Ebra for bridging/config/switchIntfConfig. Also,
   # Forwarding agents should start only after Qos has completed publishing info
   # into qos/status
   sh.registerStageDependency( "QosStatusUpdate", [ "ErrdisableStatusUpdate" ] )
   sh.registerStage( "Qos", "QosStatusUpdate", timeout=60 )

   sh.registerStageDependency( "StrataMmuReconcile", [ "SecondaryHardwareAgent",
                                                       "QosStatusUpdate" ] )
   sh.registerStage( "Strata", "StrataMmuReconcile", complete=True,
                     timeout=120 )
   
   sh.registerStageDependency( "CesSubportModuleInfoUpdate",
                               [ "SecondaryHardwareAgent", "StrataMmuReconcile" ] )
   sh.registerStageDependency( "CesSubportModuleInfoUpdateReady",
                               [ "CesSubportModuleInfoUpdate" ])

   sh.registerStage( "StrataCentral", "ModuleConfigUpdate",
                     [ "LaunchConfigUpdate", "SecondaryHardwareAgent",
                       "CesSubportModuleInfoUpdateReady" ], timeout=120 )
   sh.registerStageDependency( "ModuleStatusUpdate",
                               [ "ModuleConfigUpdate" ] )
   
   sh.registerStageDependency( "LinkStatusUpdate", [ "ErrdisableStatusUpdate",
                                                     "StrataMmuReconcile" ] )
   sh.registerStage( "Strata", "LinkStatusUpdate", complete=True,
                     timeout=120 )

   # The XcvrAgent reacts to link changes and interface state changes.  When link
   # state and interface state is updated during hitless reload, the XcvrAgent must
   # not react because it may affect the link.  This 'XcvrConfigAllowed' stage will
   # be started (and auto completed) once the LinkStatusUpdate stage is complete.
   # Once 'XcvrConfigAllowed' is complete, the XcvrAgent is allowed to react to
   # interface state changes.
   sh.registerStageDependency( "XcvrConfigAllowed", [ "LinkStatusUpdate" ] )

   # Dot1x agent depends on Ebra for bridging/config/switchIntfConfig and Ira
   # for Ira-IpStatus-deps-include. Also wait till linkStatus is known
   # and Lldp populates the neighbor classifications before starting Dot1x.
   sh.registerStageDependency( "NeighborClassificationReady",
                               [ "LinkStatusUpdate", "NetworkAgent" ] )
   sh.registerStage( "Lldp", "NeighborClassificationReady", timeout=120 )
   sh.registerStageDependency( "Dot1xStatusReady",
                               [ "NeighborClassificationReady" ] )
   sh.registerStage( "Dot1x", "Dot1xStatusReady", timeout=120 )

   # Start Bfd agent before Lag enters LagStatusUpdate stage. Wait till
   # linkStatus is known before starting Bfd.
   sh.registerStageDependency( "BfdStatusUpdate", [
                               "LinkStatusUpdate", "FeatureAgent" ] )
   sh.registerStage( "Bfd", "BfdStatusUpdate", timeout=60 )

   sh.registerStageDependency( "PlatformBfdStatusUpdate", [ "BfdStatusUpdate" ] )
   sh.registerStage( "StrataBfd", "PlatformBfdStatusUpdate", complete=True )

   sh.registerStageDependency( "HwLagPhyIntfReady", [ "LinkStatusUpdate",
                                                      "ModuleStatusUpdate" ] )
   sh.registerStage( "StrataLag", "HwLagPhyIntfReady", timeout=60 )
   sh.registerStage( "StrataL2Combo", "HwLagPhyIntfReady", timeout=60,
                     completeNotRunnable=True )
   # Lag status reconcile can only happen after Lag agent is started and
   # platform agent publish HW Lag groups under hardware/lag/input/config and
   # also updated link speed
   sh.registerStageDependency( "LagStatusReconcile",
         [ "NetworkAgent", "SecondaryHardwareAgent",
           "LinkStatusUpdate", "LagIntfStatusReady", "HwLagPhyIntfReady" ] )
   sh.registerStage( "Lag", "LagStatusReconcile", timeout=30 )

   sh.registerStageDependency( "HwLagStatusReconcile",
                               [ "ModuleStatusUpdate", "LinkStatusUpdate",
                                 "LagStatusReconcile", "FeatureAgent" ] )
   sh.registerStage( "StrataLag", "HwLagStatusReconcile", timeout=60 )
   sh.registerStage( "StrataL2Combo", "HwLagStatusReconcile", timeout=60,
                     completeNotRunnable=True )

   sh.registerStageDependency( "PStoreRestore", [
                               "FeatureAgent" ] )
   sh.registerStage( "Mlag", "PStoreRestore", timeout=60 )

   sh.registerStageDependency( "LagStatusUpdate",
                                 [ "HwLagStatusReconcile",
                                   "BfdStatusUpdate" ] )
   sh.registerStage( "Lag", "LagStatusUpdate", timeout=60 )

   # Start BridgeIdUpdate after Lag Agent finishes updating the EthLagIntfStatus
   # for port-channel, so that peer-link can come up for Mlag to be formed
   # This stage is run only when Mlag is configured. On non-mlag switch,
   # BridgeIdUpdate will be autoCompleted by Launcher.

   # Start MlagTunnel in BridgeIdUpdate stage since it creates the 'mlag_hb' device
   # which is needed by Mlag to do PeerMounting successfully
   sh.registerStage( "MlagTunnel", "BridgeIdUpdate", complete=True )
   sh.registerStage( "Mlag", "BridgeIdUpdate", timeout=60 )

   # Start StpUpdateStage with Stp after BridgeIdUpdate, so that Mlag can
   # override Stp and prevent Stp to start with local BridgeId and there
   # not caouse any churn in the port states when the STP BridgeId changes.
   sh.registerStageDependency( "StpUpdateStage", [ "BridgeIdUpdate" ] )
   sh.registerStage( "StpTxRx", "StpUpdateStage", complete=True )
   sh.registerStage( "Stp", "StpUpdateStage", timeout=120 )

   # Start LacpTxAgent after Lag agent finishes its initialization to prevent
   # sending inconsistent LACP state to the partner
   sh.registerStageDependency( "LacpTxStatusUpdate", [ "LagStatusUpdate" ] )
   sh.registerStage( "LacpTxAgent", "LacpTxStatusUpdate", complete=True )

   sh.registerStageDependency( "StrataLagStatusUpdate",
                               [ "LagStatusUpdate", "HwLagStatusReconcile" ] )
   sh.registerStage( "StrataLag", "StrataLagStatusUpdate", timeout=30 )
   sh.registerStage( "StrataL2Combo", "StrataLagStatusUpdate", timeout=30,
                     completeNotRunnable=True )

   # StrataQosV2 agent update
   sh.registerStage( "StrataQosV2", "StrataQosV2BasicMapsReadyUpdate",
                     timeout=120,
                     completeNotRunnable=True )
   sh.registerStageDependency( "StrataQosV2BasicMapsReadyUpdate",
                               [ "ModuleStatusUpdate" ])
   sh.registerStage( "StrataQosV2", "StrataQosV2AclReadyUpdate",
                     timeout=120,
                     completeNotRunnable=True )
   sh.registerStageDependency( "StrataQosV2AclReadyUpdate",
                               [ "ModuleStatusUpdate" ])
   sh.registerStage( "StrataQosV2", "StrataQosV2EcnWredReadyUpdate",
                     timeout=120,
                     completeNotRunnable=True )
   sh.registerStageDependency( "StrataQosV2EcnWredReadyUpdate",
                               [ "ModuleStatusUpdate" ])
   sh.registerStage( "StrataQosV2", "StrataQosV2ReadyUpdate",
                     completeNotRunnable=True )
   sh.registerStageDependency( "StrataQosV2ReadyUpdate",
                               [ "StrataQosV2BasicMapsReadyUpdate",
                                 "StrataQosV2AclReadyUpdate",
                                 "StrataQosV2EcnWredReadyUpdate" ])
   # Vxlan agent update
   sh.registerStageDependency( "VxlanConfigUpdate", [ "NetworkAgent" ] )
   sh.registerStage( "Vxlan", "VxlanConfigUpdate", timeout=60 )
   sh.registerStageDependency( "VxlanAsuSync", [ "VxlanConfigUpdate",
                                                      "BridgeIdUpdate" ] )
   sh.registerStage( "Vxlan", "VxlanAsuSync", timeout=60 )

   sh.registerStageDependency( "VlanIntfOperStatusUpdate", [ "StrataLagStatusUpdate",
                                                             "Dot1xStatusReady" ] )
   sh.registerStage( "Ebra", "VlanIntfOperStatusUpdate", timeout=30 )

   sh.registerStageDependency( "BridgeIdUpdate", [
                               "LagStatusUpdate", "PStoreRestore",
                               "VlanIntfOperStatusUpdate" ] )

   sh.registerStageDependency( "DynVlanIntfOperStatusUpdate",
                               [ "VxlanAsuSync" ] )
   sh.registerStage( "Ebra", "DynVlanIntfOperStatusUpdate", timeout=30 )

   sh.registerStageDependency( "EbraStatusUpdate", [ "VlanIntfOperStatusUpdate",
                                                   "DynVlanIntfOperStatusUpdate" ] )
   # In EbraAsuSm, we have a timer "maxEbraStatusUpdateTime" (115s) to make sure
   # Ebra marks EbraStatusUpdate stage as complete before StageMgr timeout. So
   # changing the timeout value in this stage also requires to udpate the timer
   # in EbraAsuSm, accordingly
   sh.registerStage( "Ebra", "EbraStatusUpdate", timeout=120 )

   # Start VxanSwFwd agent
   sh.registerStageDependency( "VxlanSwFwdStatusUpdate", [ "VxlanConfigUpdate" ] )
   sh.registerStage( "VxlanSwFwd", "VxlanSwFwdStatusUpdate", complete=True )

   # PI Mirroring is dependent on LinkStatusUpdate being published.
   sh.registerStageDependency( "MirroringHwConfigUpdate", [ "LinkStatusUpdate" ] )
   sh.registerStage( "Mirroring", "MirroringHwConfigUpdate", timeout=60 )

   # StrataVlanTopo depends on TopoConfig creation for BridgingTopoInstUpdate
   sh.registerStageDependency( "BridgingTopoConfigCreate",
                               [ "NetworkAgent", "FeatureAgent" ] )
   sh.registerStage( "StpTopology", "BridgingTopoConfigCreate", timeout=60 )

   sh.registerStageDependency( "BridgingTopoInstUpdate",
                               [ "ModuleStatusUpdate", "EbraStatusUpdate",
                                 "StrataLagStatusUpdate",
                                 "BridgingTopoConfigCreate" ] )
   sh.registerStage( "StrataVlanTopo", "BridgingTopoInstUpdate", timeout=120 )
   sh.registerStage( "StrataL2Combo", "BridgingTopoInstUpdate", timeout=120,
                     completeNotRunnable=True )

   sh.registerStageDependency( "BridgingTopoStatusUpdate",
                               [ "BridgingTopoInstUpdate" ] )
   sh.registerStage( "TopoAgent", "BridgingTopoStatusUpdate", timeout=60 )

   sh.registerStageDependency( "BridgingTopoConfigUpdate",
                               [ "StpUpdateStage",
                                 "BridgingTopoStatusUpdate" ] )

   sh.registerStage( "StpTopology", "BridgingTopoConfigUpdate", 
                     enableAutoComplete=True, autoCompleteTimeout=60 )

   sh.registerStageDependency( "VxlanConfigReconcile",
                               [ "ModuleStatusUpdate",
                                 "VxlanAsuSync" ] )

   sh.registerStage( "StrataL3", "VxlanConfigReconcile", complete=True, timeout=60 )

   sh.registerStageDependency( "StrataVxlanVirtualPortListUpdate",
                               [ "ModuleStatusUpdate",
                                 "HwLagStatusReconcile" ] )
   sh.registerStage( "StrataL3", "StrataVxlanVirtualPortListUpdate", timeout=60 )


   sh.registerStageDependency( "StrataVxlanVirtualPortListReconcile",
                                  [ "ModuleStatusUpdate",
                                    "StrataVxlanVirtualPortListUpdate",
                                    "VxlanConfigReconcile" ] )

   sh.registerStage( "StrataL2", "StrataVxlanVirtualPortListReconcile", timeout=60 )

   sh.registerStageDependency( "L2MacTblShadowReconcile",
                               [ "ModuleStatusUpdate", "StrataLagStatusUpdate",
                                 "LinkStatusUpdate",
                                 "StrataVxlanVirtualPortListReconcile" ] )
   sh.registerStage( "StrataL2", "L2MacTblShadowReconcile", timeout=120 )

   # L2MacAddrSmUpdate uses the dot1x host table to reconcile hardware saved
   # configuredStaticMac entries to authenticatedMac entries, so requires
   # that the restoration of the dot1x host table is completed before running,
   # thus the dependency on Dot1xStatusReady
   sh.registerStageDependency( "L2MacAddrSmUpdate",
                               [ "EbraStatusUpdate",
                                 "L2MacTblShadowReconcile",
                                 "BridgingTopoConfigUpdate",
                                 "Dot1xStatusReady" ] )
   sh.registerStage( "StrataL2", "L2MacAddrSmUpdate", timeout=120 )

   sh.registerStageDependency( "L2SubIntfReconcile", [ "L2MacAddrSmUpdate" ] )
   sh.registerStageDependency( "StrataSubIntfReconcile", [ "L2MacAddrSmUpdate" ] )
   sh.registerStage( "StrataL2", "L2SubIntfReconcile", timeout=120 )
   sh.registerStage( "Strata", "StrataSubIntfReconcile", complete=True, timeout=120 )

   sh.registerStageDependency( "EbraSubIntfUp",
                               [ "EbraStatusUpdate", "L2SubIntfReconcile",
                                 "StrataSubIntfReconcile" ] )
   # In EbraAsuSm, we have a timer "maxEbraSubINtfUpTime" (55s) to make sure
   # Ebra marks maxEbraSubINtfUpTime stage as complete before StageMgr timeout. So
   # changing the timeout value in this stage also requires to udpate the timer
   # in EbraAsuSm, accordingly
   sh.registerStage( "Ebra", "EbraSubIntfUp", timeout=60 )

   sh.registerStageDependency( "VrfStatusUpdate",
                               [ "EbraStatusUpdate", "EbraSubIntfUp" ] )
   sh.registerStage( "Ira", "VrfStatusUpdate", timeout=60 )

   sh.registerStageDependency( "VrfRoutingInfoUpdate", [ "VrfStatusUpdate" ] )
   sh.registerStage( "IpRib", "VrfRoutingInfoUpdate", timeout=60 )

   sh.registerStageDependency( "IpIntfStatusUpdate", [ "VxlanAsuSync",
                                                       "VrfRoutingInfoUpdate" ] )
   sh.registerStage( "Ira", "IpIntfStatusUpdate", timeout=60 )
   sh.registerStage( "Bgp", "IpIntfStatusUpdate", timeout=60 )

   sh.registerStageDependency( "ArpStatusUpdate", [ "EbraStatusUpdate",
                                                       "IpIntfStatusUpdate" ] )

   sh.registerStage( "Arp", "ArpStatusUpdate", timeout=60 )

   if toggleStrataIgmpSnoopingAsuEnabled():
      sh.registerStageDependency( "L2SnoopReconcile", [ "ArpStatusUpdate" ] )
      sh.registerStage( "IgmpSnooping", "L2SnoopReconcile", timeout=600 )

   sh.registerStageDependency( "FibRouteUpdate", [ "ArpStatusUpdate" ] )
   sh.registerStage( "Rib", "FibRouteUpdate", timeout=60 )
   sh.registerStage( "Rib-vrf", "FibRouteUpdate", timeout=60 )
   sh.registerStage( "Bgp", "FibRouteUpdate", timeout=60 )
   sh.registerStage( "ConnectedRoute", "FibRouteUpdate", timeout=60 )
   sh.registerStage( "RouteInput", "FibRouteUpdate", timeout=60 )
   sh.registerStage( "Isis", "FibRouteUpdate", timeout=60 )
   sh.registerStage( "Isis-vrf", "FibRouteUpdate", timeout=60 )
   sh.registerStage( "Ospf", "FibRouteUpdate", timeout=60 )
   sh.registerStage( "Ospf-vrf", "FibRouteUpdate", timeout=60 )
   sh.registerStage( "Ospf3", "FibRouteUpdate", timeout=60 )
   sh.registerStage( "Ospf3-vrf", "FibRouteUpdate", timeout=60 )

   sh.registerStageDependency( "L3FibReady", [ "FibRouteUpdate" ] )
   sh.registerStage( "StrataL3", "L3FibReady", timeout=600 )

   sh.registerStageDependency( "L2RibUpdate", [ "L3FibReady",
                                                "Dot1xStatusReady",
                                                "L2MacAddrSmUpdate" ] )

   sh.registerStage( "Dot1x", "L2RibUpdate", enableAutoComplete=True,
                     autoCompleteTimeout=120 )
   sh.registerStage( "Bgp", "L2RibUpdate", enableAutoComplete=True,
                     autoCompleteTimeout=120 )
   sh.registerStage( "StrataL2", "L2RibUpdate", enableAutoComplete=True,
                     autoCompleteTimeout=120 )

   sh.registerStageDependency( "L2RibReconcile", [ "L2RibUpdate" ] )

   sh.registerStage( "L2Rib", "L2RibReconcile", enableAutoComplete=True,
                     autoCompleteTimeout=60 )

   sh.registerStageDependency( "L2RibReady", [ "L2RibReconcile" ] )

   sh.registerStage( "Bgp", "L2RibReady", enableAutoComplete=True,
                     autoCompleteTimeout=120 )
   sh.registerStage( "StrataL2", "L2RibReady", enableAutoComplete=True,
                     autoCompleteTimeout=120 )

   sh.registerStageDependency( "L2MacAddrSmReconcile", [ "L2RibReady" ] )
   sh.registerStage( "StrataL2", "L2MacAddrSmReconcile", timeout=120 )

   sh.registerStageDependency( "L2McastSmReconcile",
                               [ "EbraStatusUpdate", "ModuleStatusUpdate",
                                 "StrataLagStatusUpdate", "IpIntfStatusUpdate",
                                 "L2MacAddrSmReconcile" ] )
   sh.registerStage( "StrataL2", "L2McastSmReconcile", timeout=120 )

   sh.registerStageDependency( "L3UcastSmsReconcile",
                                  [ "ArpStatusUpdate", "L3FibReady",
                                    "L2MacAddrSmReconcile",
                                    "StrataLagStatusUpdate" ] )
   sh.registerStage( "StrataL3", "L3UcastSmsReconcile", timeout=120 )


   sh.registerStageDependency( "MrouteReconstructUpdate",
                               [ "ModuleStatusUpdate" ] )
   sh.registerStage( "StrataL3", "MrouteReconstructUpdate", timeout=60 )

   # Pim is dependent on IP interfaces being published.
   sh.registerStageDependency( "PimIntfUpdate", [ "IpIntfStatusUpdate" ] )
   sh.registerStage( "Pim", "PimIntfUpdate", timeout=600 )

   sh.registerStageDependency( "Pim6IntfUpdate", [ "IpIntfStatusUpdate" ] )
   sh.registerStage( "Pim6", "Pim6IntfUpdate", timeout=600 )

   # Pimsm is dependent on Pim interfaces being published.
   sh.registerStageDependency( "MfibRouteUpdate",
                               [ "PimIntfUpdate", "MrouteReconstructUpdate" ] )
   sh.registerStage( "Pimsm", "MfibRouteUpdate", timeout=600 )

   sh.registerStageDependency( "Mfib6RouteUpdate",
                               [ "Pim6IntfUpdate", "MrouteReconstructUpdate" ] )
   sh.registerStage( "Pimsm6", "Mfib6RouteUpdate", timeout=600 )

   # PimBidir is dependent on Pim interfaces being published.
   sh.registerStageDependency( "MfibBidirRouteUpdate", [ "PimIntfUpdate" ] )
   sh.registerStage( "PimBidir", "MfibBidirRouteUpdate", timeout=600 )

   sh.registerStageDependency( "L3MfibReady",
                               [ "MfibRouteUpdate", "Mfib6RouteUpdate",
                                 "L3FibReady" ] )
   sh.registerStage( "StrataL3", "L3MfibReady", timeout=600 )

   if toggleStrataIgmpSnoopingAsuEnabled():
      sh.registerStageDependency( "L3McastSmsReconcile",
                                  [ "L2SnoopReconcile", 
                                    "MrouteReconstructUpdate", "L3UcastSmsReconcile",
                                    "L3MfibReady" ] )
   else:
      sh.registerStageDependency( "L3McastSmsReconcile",
                                  [ "MrouteReconstructUpdate", 
                                    "L3UcastSmsReconcile",
                                    "L3MfibReady" ] )

   sh.registerStage( "StrataL3", "L3McastSmsReconcile", timeout=60 )

   sh.registerStageDependency( "VlanReconcile",
                               [ "BridgingTopoConfigUpdate", "LinkStatusUpdate",
                                 "L3UcastSmsReconcile", "L3McastSmsReconcile" ] )
   sh.registerStage( "StrataVlanTopo", "VlanReconcile", timeout=120 )
   sh.registerStage( "StrataL2Combo", "VlanReconcile", timeout=120,
                     completeNotRunnable=True )

   sh.registerStageDependency( "StrataSliceL2AgentReconcile",
                               [ "StrataMmuReconcile", "StrataLagStatusUpdate",
                                 "L2MacAddrSmReconcile", "L2McastSmReconcile" ] )
   sh.registerStage( "Strata", "StrataSliceL2AgentReconcile", complete=True,
                     timeout=600 )

   # Stage to notify that Vxlan Unicast Tunnel configs are ready
   sh.registerStageDependency( "VxlanUCTunnelsUpdate",
                               [ "VxlanConfigReconcile",
                                 "L3UcastSmsReconcile",
                                 "StrataSliceL2AgentReconcile" ] )
   sh.registerStage( "StrataL2", "VxlanUCTunnelsUpdate", timeout=120 )

   sh.registerStageDependency( "VxlanUCTunnelsReconcile",
                                  [ "ModuleStatusUpdate",
                                    "VxlanConfigUpdate",
                                    "VxlanUCTunnelsUpdate" ] )

   # Stage to notify that vxlan is ready on l3 agent
   sh.registerStageDependency( "L3VxlanReadyUpdate",
                               [ "L3McastSmsReconcile",
                                 "VxlanUCTunnelsReconcile" ] )
   sh.registerStage( "StrataL3", "L3VxlanReadyUpdate", timeout=120 )

   sh.registerStageDependency( "PrepareL3TableFastWrites",
                               [ "L3VxlanReadyUpdate" ] )
   sh.registerStage( "StrataL3", "PrepareL3TableFastWrites", timeout=60 )

   # Stage to notify that vxlan is ready on l2 agent
   sh.registerStageDependency( "L2VxlanReadyUpdate",
                               [ "L3VxlanReadyUpdate" ] )

   # StrataL2 marks the stage complete after 300 seconds
   sh.registerStage( "StrataL2", "L2VxlanReadyUpdate", timeout=360 )

   sh.registerStage( "StrataL3", "VxlanUCTunnelsReconcile", timeout=120 )

   sh.registerStageDependency( "StrataLagSvpReconcile",
                               [ 'HwLagStatusReconcile',
                                 'VxlanUCTunnelsUpdate' ] )
   sh.registerStage( "StrataLag", "StrataLagSvpReconcile", timeout=60 )
   sh.registerStage( "StrataL2Combo", "StrataLagSvpReconcile", timeout=60,
                     completeNotRunnable=True )

   sh.registerStageDependency( "StrataMmuAgentReconcile",
                               [ "ModuleStatusUpdate",
                                 "LinkStatusUpdate" ] )
   sh.registerStage( "StrataMmu", "StrataMmuAgentReconcile", complete=True,
                     completeNotRunnable=True )

   # StrataMirroring state machines in turn depend on PI stage being published
   # as well as LagStatusUpdate
   sh.registerStageDependency( "StrataMirroringReconcile",
                               [ "MirroringHwConfigUpdate",
                                 "StrataLagStatusUpdate",
                                 "L3UcastSmsReconcile" ] )
   sh.registerStage( "StrataMirror", "StrataMirroringReconcile", timeout=60 )
   # Once StrataMirroring has reconciled, Strata needs to reconcile Mirror bits
   # in port table entry
   sh.registerStageDependency( "StrataMirroringPortEntryReconcile",
                               [ "StrataMirroringReconcile",
                                 "StrataSliceL2AgentReconcile" ] )
   sh.registerStage( "Strata", "StrataMirroringPortEntryReconcile", complete=True,
                     timeout=60 )

   sh.registerStageDependency( "StrataSliceL3AgentReconcile",
                               [ "L3UcastSmsReconcile",
                                 "L3McastSmsReconcile",
                                 "StrataSliceL2AgentReconcile" ] )
   sh.registerStage( "Strata", "StrataSliceL3AgentReconcile", complete=True,
                     timeout=120 )

   sh.registerStageDependency( "StrataSliceVxlanReconcile",
                               [ "L2VxlanReadyUpdate",
                                 "StrataSliceL2AgentReconcile" ] )
   sh.registerStage( "Strata", "StrataSliceVxlanReconcile", timeout=120,
                     complete=True )

   sh.registerStageDependency( "DownLinksUpdate",
                               [ "VlanReconcile", ] )
   sh.registerStage( "Ebra", "DownLinksUpdate", timeout=30 )

   sh.registerStageDependency( "StrataLagSvpReconcile",
                               [ 'HwLagStatusReconcile',
                                 'VxlanUCTunnelsUpdate' ] )
   sh.registerStage( "StrataLag", "StrataLagSvpReconcile", timeout=60 )
   sh.registerStage( "StrataL2Combo", "StrataLagSvpReconcile", timeout=60,
                     completeNotRunnable=True )

   sh.registerStageDependency( "LagVlanStatusUpdate",
                               [ "VlanReconcile", ] )
   sh.registerStage( "StrataLag", "LagVlanStatusUpdate", timeout=60 )
   sh.registerStage( "StrataL2Combo", "LagVlanStatusUpdate", timeout=60,
                     completeNotRunnable=True )

   sh.registerStageDependency( "PreQuiesceTraffic",
                               [ "L2VxlanReadyUpdate",
                                 "L3McastSmsReconcile",
                                 "PrepareL3TableFastWrites",
                                 "StrataMirroringReconcile",
                                 "VlanReconcile",
                                 "LagVlanStatusUpdate",
                                 "StrataSliceL2AgentReconcile",
                                 "StrataSliceL3AgentReconcile",
                                 "StrataSliceVxlanReconcile",
                                 "StrataLagSvpReconcile",
                                 "StrataQosV2ReadyUpdate" ] )
   sh.registerStage( "StrataL3", "PreQuiesceTraffic", timeout=60 )
   sh.registerStage( "StrataL2", "PreQuiesceTraffic", timeout=60 )
   sh.registerStage( "Strata", "PreQuiesceTraffic", complete=True, timeout=60 )

   sh.registerStageDependency( "QuiesceTraffic",
                               [ "PreQuiesceTraffic", ] )
   sh.registerStage( "Strata", "QuiesceTraffic", complete=True, timeout=60 )

   sh.registerStageDependency( "BulkDownloadStart",
                               [ "QuiesceTraffic", ] )
   sh.registerStage( "StrataL3", "BulkDownloadStart", timeout=60 )
   sh.registerStage( "StrataLag", "BulkDownloadStart", timeout=60 )
   sh.registerStage( "StrataL2", "BulkDownloadStart", timeout=60 )
   sh.registerStage( "StrataMirror", "BulkDownloadStart", timeout=60 )
   sh.registerStage( "StrataVlanTopo", "BulkDownloadStart", timeout=60 )
   sh.registerStage( "StrataL2Combo", "BulkDownloadStart", timeout=60,
                     completeNotRunnable=True )
   sh.registerStage( "StrataSec", "BulkDownloadStart", timeout=60,
         completeNotRunnable=True )
   sh.registerStage( "Strata", "BulkDownloadStart", complete=True, timeout=60 )
   if toggleStrataTileSsuEnabled():
      sh.registerStage( "StrataTile", "BulkDownloadStart", timeout=60,
            completeNotRunnable=True )

   sh.registerStageDependency( "BulkDownloadComplete",
                               [ "BulkDownloadStart", ] )
   sh.registerStage( "StrataL3", "BulkDownloadComplete", timeout=60 )
   sh.registerStage( "Strata", "BulkDownloadComplete", complete=True,
                     timeout=60 )
   sh.registerStage( "StrataSec", "BulkDownloadComplete", complete=True, timeout=60,
         completeNotRunnable=True )
   sh.registerStageDependency( "SliceStatusReady",
                               [ "BulkDownloadComplete", ] )
   sh.registerStage( "Strata", "SliceStatusReady", complete=True,
                     timeout=60 )
   
   sh.registerStageDependency( "ReadNewMacEntriesReady",
                               [ "BulkDownloadComplete", ] )
   sh.registerStage( "StrataL2", "ReadNewMacEntriesReady", complete=True,
                     timeout=60 )

   # counters needs parity correction to be enabled to prevent a crash
   sh.registerStageDependency( "CountersStart",
                               [ "SliceStatusReady", ] )
   sh.registerStage(
         "StrataCounters",
         "CountersStart",
         completeNotRunnable=True,
         timeout=60 )

   sh.registerStageDependency( "StpNormalOperation",
                               [ "SliceStatusReady" ] )
   sh.registerStage( "Stp", "StpNormalOperation", timeout=60 )

   sh.registerStageDependency( "DownLinksUpdate",
                               [ "SliceStatusReady" ] )

   bootSanityCheckDeps = []
   bootSanityCheckDeps += [ "DownLinksUpdate" ]
   bootSanityCheckDeps += [ "StrataMirroringPortEntryReconcile" ]
   bootSanityCheckDeps += [ "VxlanUCTunnelsReconcile" ]
   bootSanityCheckDeps += [ "StrataMmuAgentReconcile" ]
   bootSanityCheckDeps += [ "StrataLagSvpReconcile" ]
   bootSanityCheckDeps += [ "L2RibReady" ]
   bootSanityCheckDeps += [ "PlatformBfdStatusUpdate" ]
   bootSanityCheckDeps += [ "LacpTxStatusUpdate" ]
   bootSanityCheckDeps += [ "VxlanSwFwdStatusUpdate" ]
   bootSanityCheckDeps += [ "CriticalAgent" ]
   bootSanityCheckDeps += [ "MfibBidirRouteUpdate" ]
   bootSanityCheckDeps += [ "XcvrConfigAllowed" ]
   bootSanityCheckDeps += [ "CountersStart" ]
   bootSanityCheckDeps += [ "ReadNewMacEntriesReady" ]
   bootSanityCheckDeps += [ "StpNormalOperation" ]
   sh.registerStageDependency( "BootSanityCheck",
                               bootSanityCheckDeps )
   sh.registerStage( "Launcher", "BootSanityCheck", timeout=120 )

