# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import StageSysdbHelper

def registerNormalBootMako( entityManager ):
   sh = StageSysdbHelper.StageHelper( entityManager, 'boot' )
   sh.applicationIs( "Mako normal boot" )
   sh.continueOnTimeoutIs( True )

   sh.registerStageDependency( "XcvrWarm", [] )
   sh.registerStage( "Xcvr", "XcvrWarm", completeNotRunnable=True, timeout=60 )

   sh.registerStageDependency( "FrontPanelPhyInit", [] )
   sh.registerStage( "PhyCortina", "FrontPanelPhyInit", complete=True )
   sh.registerStage( "CortinaApiProxy", "FrontPanelPhyInit", complete=True )

   sh.registerStageDependency( "LinkStatusUpdate", [ "FrontPanelPhyInit" ] )
   sh.registerStage( "MakoCentral", "LinkStatusUpdate", timeout=600 )

   sh.registerStageDependency( "FpgaHardwareAgent",
                               [ "XcvrWarm", 
                                 "LinkStatusUpdate" ] )
   sh.registerStage( "MakoFpgaAgent-FixedSystem", "FpgaHardwareAgent",
      complete=True )
