# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from StageMgrPluginBase import StageMgrDynRegBase
import Tracing

_scdStageMgrPlugin = None
traceHandle = Tracing.Handle( 'ScdStageMgrPlugin' )
t0 = traceHandle.trace0

class ScdStageMgrPlugin( StageMgrDynRegBase ):
   def registerDynamicStages( self ):
      t0( 'ScdStageMgrPlugin::registerDynamicStages' )
      scdNames = self.pstoreReader( 'Scd', 'scdNames', defaultItems=[ 'Scd' ] )
      for scdName in scdNames:
         self.registerAgentName( scdName )

   def registerAgentName( self, agentName ):
      # pylint: disable-next=consider-using-f-string
      t0( 'Registering stages for agent %s' % agentName )
      if 'Linecard' not in agentName:
         stages = [ 'PrimaryAgent' ]
      else:
         stages = [ 'XcvrWarm' ]
      for stage in stages:
         self.registerStage( agentName, stage )

def Plugin( entityManager ):
   t0( 'Loading Scd StageMgrPlugin' )
   global _scdStageMgrPlugin
   _scdStageMgrPlugin = ScdStageMgrPlugin( entityManager )
