# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
from StorageDevicesFirmware import StorageDevice, readHeader, readBin, fw_path
from StorageDevicesFirmware import StorageFirmwareVersion
import Tac

models = [ "StorFly_VSFBM4CC030G-150", "StorFly_VSFBM4CC120G-150",
      "StorFly_VSFBM4XC016G-150" ]

class VirtiumFirmwareVersion( StorageFirmwareVersion ):
   def __int__( self ):
      ver = self.version.split( '-' )
      str_ver = str( int( ver[ 0 ] ) ) + ver[ 1 ]
      return int( str_ver )

class Virtium( StorageDevice ):
   def __init__( self, dev, name, fwRev ):
      super( Virtium, self ).__init__( dev, name, fwRev )
      self.fw_file = ''

   def getLocalVersion( self ):
      fw_info = readHeader( self.name, fw_path )
      return VirtiumFirmwareVersion( fw_info.version )

   def getHwVersion( self ):
      return VirtiumFirmwareVersion( self.fwRev )

   # Test case: testUpgradeCmd
   def getUpgradeCommand( self ):
      self.fw_file = readBin( self.name, fw_path )
      upgradeCmd = ( "hdparm --yes-i-know-what-i-am-doing "
      "--please-destroy-my-drive --fwdownload-mode3 %s %s"
      % ( self.fw_file, self.dev ) )
      return list( upgradeCmd.split( " " ) )

   def postUpgradeReboot( self ):
      return True

def Plugin( context ):
   for model in models:
      context.models[ model ] = Virtium
