# Copyright (c) 2010, 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Cell, SuperServer, Tac  

import Tracing
t0 = Tracing.trace0
__defaultTraceHandle__ = Tracing.Handle( "SessionTimeout" )


class SessionTimeoutAgent( SuperServer.SuperServerAgent ):
   def __init__( self, entityManager ):
      SuperServer.SuperServerAgent.__init__( self, entityManager )
      mg = entityManager.mountGroup()
      self.sshConfig_ = mg.mount( 'mgmt/ssh/config', 
                            'Mgmt::Ssh::Config', 'r' )
      self.telnetConfig_ = mg.mount( 'mgmt/telnet/config', 
                               'Mgmt::Telnet::Config', 'r' )
      self.consoleConfig_ = mg.mount( 'mgmt/console/config', 
                                'Mgmt::Console::Config', 'r' )
      self.aaaStatus_ = mg.mount( Cell.path( 'security/aaa/status' ), 
                                  'Aaa::Status', 'r' )
      def _finish():
         # pylint: disable-next=attribute-defined-outside-init
         self.service_ = self.agentRoot_.newEntity( 
            "Mgmt::SessionTimeout::Root", "sessionTimeoutAgent" )

         self.service_.sessionTimeoutSm = (
            Tac.activityManager.clock,
            self.sshConfig_, 
            self.telnetConfig_, 
            self.consoleConfig_,
            self.aaaStatus_ )

      mg.close( _finish )

   def warm( self ):
      return True

def Plugin( ctx ):
   ctx.registerService( SessionTimeoutAgent( ctx.entityManager ) )
