# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Swag
import re

def getIntfId( intfId, memberId ):
   if not Swag.swagMode():
      return intfId

   assert memberId
   match = re.search( r"([a-zA-Z]+)([\d/]+)", intfId )
   assert match
   assert match.group( 1 ) and match.group( 2 )
   return f"{match.group( 1 )}{memberId}/{match.group( 2 )}"

def getSliceId( sliceId, memberId ):
   if not Swag.swagMode():
      return sliceId

   if 'FixedSystem' in sliceId:
      return f"Linecard{memberId}"
   match = re.search( r"([a-zA-Z]+)(\d+)(-\d+)?", sliceId )
   assert match
   assert match.group( 1 )
   modularizedSliceId = f"{match.group( 1 )}{memberId}"
   if match.group( 3 ):
      modularizedSliceId += match.group( 3 )
   return modularizedSliceId

def getSlicifiedAgentName( agentName, memberId ):
   if not Swag.swagMode():
      return agentName

   match = re.search( r"([A-Za-z]+)-([A-Za-z]+)(\d+)(-\d+)?", agentName )
   assert match
   assert match.group( 1 ) and match.group( 2 )
   modularizedAgentName = f"{match.group( 1 )}-{match.group( 2 )}{memberId}"
   if match.group( 4 ):
      modularizedAgentName += match.group( 4 )
   return modularizedAgentName
