# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import argparse
import os
import shutil
import sys

from Swi import rpm

def extraFileUpdate( rpmdbdir ):
   # Extract the workdir from the rpmdbdir
   workdir = os.path.dirname( rpmdbdir )

   filesUpdated = []
   filesToUpdate = [
      ( '/usr/share/Aboot/boot0', 'boot0' ),
      ( '/usr/share/AbootEos/initrd-i386', 'initrd-i386' ),
      ( '/usr/share/AbootEos/initrd-i386-kdump', 'initrd-i386-kdump' ),
   ]
   for ( wsPath, swiPath ) in filesToUpdate:
      if not os.path.exists( wsPath ):
         continue
      workdirPath = os.path.join( workdir, swiPath )
      shutil.copy( wsPath, workdirPath )
      filesUpdated.append( swiPath )
   return filesUpdated

def freshenHandler( args=None ):
   if args is None:
      args = sys.argv[ 1: ]
   op = argparse.ArgumentParser(
         prog="swi freshen",
         description="Freshen RPMs in a SWI file with those built in this workspace",
         usage="usage: %(prog)s [--fast] [-o <file>] EOS.swi [options]" )
   rpm.addRpmOptions( op )
   op.add_argument( '--no-extra-file-update', action='store_true',
                    help='Skip updating extra files (initrd files, boot0, etc)' )
   op.add_argument( 'SWI',
                    help='The image to freshen' )
   opts = op.parse_args( args )

   extraFns = None if opts.no_extra_file_update else [ extraFileUpdate ]

   rpm.rpm( opts.SWI, opts, "-v", "--nodeps", "-F", "/RPMS/*.rpm",
            extraFns=extraFns )
