#!/usr/bin/env python3
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Swi
import SwimHelperLib
import argparse
import os
import sys

def swiSupports( image ):
   def swiSupportsWithinExtractedSwi( rootDir ):
      excludePackagesPath = os.path.join( rootDir, 'etc/EosPkgExclude.d' )

      print()
      print( image, "supports the following platforms:" )
      for f in os.listdir( excludePackagesPath ):
         if f.endswith( ".exclude" ):
            print( f[ : -len( ".exclude" ) ] )
      print()

   optimization = None
   if SwimHelperLib.isSwimImage( image ):
      optimization = SwimHelperLib.getSupersetRootfs( image,
                                                      failOnMissing=True )[ 0 ]
   Swi.inSwi( image, [ swiSupportsWithinExtractedSwi ], readOnly=True,
              optimization=optimization )

def supportsHandler( args=None ):
   if args is None:
      args = sys.argv[ 1: ]

   op = argparse.ArgumentParser(
      prog="swi supports",
      description="List the hardware platforms supported by the swi",
      usage="%(prog)s EOS.swi [-p product]" )

   _, args = op.parse_known_args( args )

   if len( args ) != 1:
      op.error( "Please provide exactly one input swi" )

   swiSupports( args[ 0 ] )

if __name__ == "__main__":
   supportsHandler()
