# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

def checkInfoSchema( info ):
   """Given the info data structure from install.yaml, check its schema"""
   try:
      # "installOnBlessedImage" should be a boolean
      if "installOnBlessedImage" in info:
         blessed = info[ "installOnBlessedImage" ]
         if not isinstance( blessed, bool ):
            raise ValueError( "installOnBlessedImage should be a boolean" )
      # "version" should be a list of dictionaries, and in each dictionary, the
      # key should be a string, the value should be a list of strings
      if "version" in info:
         errMsg = "version has invalid syntax"
         versionInfo = info[ "version" ]
         if not isinstance( versionInfo, list ):
            raise ValueError( errMsg )
         for versionGroup in versionInfo:
            if not isinstance( versionGroup, dict ):
               raise ValueError( errMsg )
            version = next( iter( versionGroup ) )
            if not isinstance( versionGroup[ version ], list ):
               raise ValueError( errMsg )
            for rpm in versionGroup[ version ]:
               if not isinstance( rpm, ( str, dict ) ):
                  raise ValueError( errMsg )
      if "agentsToRestart" in info:
         errMsg = "'agentsToRestart' should be a list of strings"
         agents = info[ "agentsToRestart" ]
         if not isinstance( agents, list ):
            raise ValueError( errMsg )
         for agent in agents:
            if not isinstance( agent, str ):
               raise ValueError( errMsg )
      if "swiFlavor" in info:
         errMsg = "'swiFlavor' should be a list of strings"
         flavors = info[ "swiFlavor" ]
         if not isinstance( flavors, list ):
            raise ValueError( errMsg )
         for f in flavors:
            if not isinstance( f, str ):
               raise ValueError( errMsg )
   except ValueError as e:
      # Format the error message
      # pylint: disable-next=consider-using-f-string,raise-missing-from
      raise ValueError( "Invalid YAML file syntax: %s" % e )
