# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import argparse
import sys
import SwiSignLib

def verifyHandler( args ):
   parser = argparse.ArgumentParser( prog="swix verify" )
   parser.add_argument( 'swixFile', metavar='FILE.swix',
                        help='Name of SWIX file to verify' )
   args = parser.parse_args( args )

   # Verify using default CA
   ( ok, errorMsg, _ ) = SwiSignLib.verifySwixSignature( args.swixFile, [ None ] )
   print( errorMsg )
   if not ok:
      sys.exit( 1 )