#!/usr/bin/env python3
# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from TypeFuture import TacLazyType

class Synce:
   #
   # Please keep the following list sorted alphanumerically.
   #
   AllCliClockConfig = TacLazyType( 'Synce::AllCliClockConfig' )
   AllClockStatus = TacLazyType( 'Synce::AllClockStatus' )
   AllEffectiveClockStatus = TacLazyType( 'Synce::AllEffectiveClockStatus' )
   AllEsmcRxStat = TacLazyType( 'Synce::AllEsmcRxStat' )
   AllEsmcTxStat = TacLazyType( 'Synce::AllEsmcTxStat' )
   BestClockStatus = TacLazyType( 'Synce::BestClockStatus' )
   BestClockStatusStatus = TacLazyType( 'Synce::BestClockStatus::Status' )
   Capability = TacLazyType( 'Synce::Hardware::Capability' )
   CliConfig = TacLazyType( 'Synce::CliConfig' )
   CliHelper = TacLazyType( 'Synce::CliHelper' )
   ClockSelectionSmState = TacLazyType( 'Synce::ClockSelectionSm::OutputState' )
   ClockSource = TacLazyType( 'Synce::ClockSource' )
   ClockSourceSmState = TacLazyType( 'Synce::ArexCode::ClockSourceSm::OutputState' )
   ClockStatus = TacLazyType( 'Synce::ClockStatus' )
   ClockStatusSmState = TacLazyType( 'Synce::ArexCode::ClockStatusSm::OutputState' )
   ClockTimerSmState = TacLazyType( 'Synce::ClockTimerSm::OutputState' )
   ClockTimerStatus = TacLazyType( 'Synce::ClockTimerStatus' )
   EecSmState = TacLazyType( 'Synce::ArexCode::EecSm::OutputState' )
   EecStatus = TacLazyType( 'Synce::EecStatus' )
   EecStatusStatus = TacLazyType( 'Synce::EecStatus::Status' )
   EffectiveBestClockStatusSmState = TacLazyType(
      'Synce::ArexCode::EffectiveBestClockStatusSm::OutputState' )
   EffectiveClockStatus = TacLazyType( 'Synce::EffectiveClockStatus' )
   EsmcPamSmState = TacLazyType( 'Synce::ArexCode::EsmcPamSm::OutputState' )
   EsmcPdu = TacLazyType( 'Synce::EsmcPdu' )
   EsmcPduWrapper = TacLazyType( 'Synce::EsmcPduWrapper' )
   EsmcRxInfo = TacLazyType( 'Synce::EsmcRxInfo' )
   EsmcRxStat = TacLazyType( 'Synce::EsmcRxStat' )
   EsmcRxStatus = TacLazyType( 'Synce::EsmcRxStatus' )
   EsmcStartupStatus = TacLazyType( 'Synce::EsmcStartupStatus' )
   EsmcStatClearRequest = TacLazyType( 'Synce::EsmcStatClearRequest' )
   EsmcTxConstants = TacLazyType( 'Synce::EsmcTxConstants' )
   EsmcTxStat = TacLazyType( 'Synce::EsmcTxStat' )
   EthDevPamCollectionSmState = TacLazyType(
      'Synce::EthDevPamCollectionSm::OutputState' )
   EthPhyClockStatus = TacLazyType( 'Synce::Hardware::EthPhyClockStatus' )
   EventFlag = TacLazyType( 'Synce::EsmcStat::EventFlag' )
   Holdoff = TacLazyType( 'Synce::Holdoff' )
   HwConfig = TacLazyType( 'Synce::Hardware::HwConfig' )
   # BUG635102: Ideally, a Tac::Optional would be used here but AReX does not yet
   # support this type.
   @staticmethod
   def HwConfigConfig( *args ):
      """
      This routine attempts to emulate an optional.
      """
      try:
         clk1, clk2 = args
      except ValueError:
         # hasValue=False as this is the default for an optional
         return TacLazyType( 'Synce::Hardware::HwConfig::Config' )()
      return TacLazyType( 'Synce::Hardware::HwConfig::Config' )( clk1, clk2, True )

   HwConfigState = TacLazyType( 'Synce::Hardware::HwConfig::State' )
   HwState = TacLazyType( 'Synce::Hardware::HwState' )
   HwStatus = TacLazyType( 'Synce::Hardware::HwStatus' )
   HwStatusState = TacLazyType( 'Synce::Hardware::HwState' )
   HwStatusStatus = TacLazyType( 'Synce::Hardware::HwStatus::Status' )
   StartupStatus = TacLazyType( 'Synce::StartupStatus' )
   NetworkOption = TacLazyType( 'Synce::NetworkOption' )
   NominatedClockStatus = TacLazyType( 'Synce::NominatedClockStatus' )
   NominatedClockStatusSmState = TacLazyType(
      'Synce::ArexCode::NominatedClockStatusSm::OutputState' )
   PllStatus = TacLazyType( 'Hardware::Dpll::PllStatus' )
   PllState = TacLazyType( 'Hardware::Dpll::PllState' )
   Priority = TacLazyType( 'Synce::Priority' )
   QlProvPrio = TacLazyType( 'Synce::QualityLevelProvPriority' )
   QualityLevel = TacLazyType( 'Synce::QualityLevel' )
   QualityLevelHelper = TacLazyType( 'Synce::QualityLevelHelper' )
   RunnabilityStatus = TacLazyType( 'Synce::RunnabilityStatus' )
   SelectedClock = TacLazyType( 'Synce::SelectedClock' )
   SelectionStartupStatus = TacLazyType( 'Synce::SelectionStartupStatus' )
   SignalFailReason = TacLazyType( 'Synce::ClockStatus::SignalFailReason' )
   SsmTuple = TacLazyType( 'Synce::SsmTuple' )
   SwitchConfig = TacLazyType( 'Synce::SwitchConfig' )
   SwitchConfigAction = TacLazyType( 'Synce::SwitchConfig::Action' )
   SynchronousMode = TacLazyType( 'Synce::SynchronousMode' )
   SyslogStatus = TacLazyType( 'Synce::SyslogStatus' )
   TimerStatus = TacLazyType( 'Synce::TimerStatus' )
   WaitToRestore = TacLazyType( 'Synce::WaitToRestore' )
   #
   # Please keep the preceding list sorted alphanumerically.
   #
