# Copyright (c) 2009, 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins
import Cell
import Tracing

__defaultTraceHandle__ = Tracing.Handle( "Lag" )
t0 = Tracing.trace0
t1 = Tracing.trace1

@Plugins.plugin( provides=( 'interface/status/lag',
                            'interface/status/eth/lag',
                            Cell.path( 'interface/status/eth/lag/local' ),
                            'hardware/lag/status' ),
                 requires=( Cell.path( 'interface/status/local' ), ) )
def Plugin( entMan ):
   t0( "Loading Lag plugin" )

   # pylint: disable-msg=W0612
   # Create lag interface collection
   intfConfig = entMan.lookup( 'interface/config/eth/lag' )
   intfStatus = entMan.lookup( 'interface/status/eth/lag' )
   intfStatusLocal = entMan.lookup( Cell.path( 'interface/status/eth/lag/local' ) )
   intfStatusInput = entMan.lookup( 'lag/input/interface/lag' )
   status = entMan.lookup( 'lag/status' )
   lagInputStatus = entMan.lookup( 'lag/input/lagphyintfstatus' )
   lagInputIntf = entMan.lookup( 'lag/input/interface' )
   inputStatus = entMan.lookup( 'lag/input/status' )
   allEthDir = entMan.allEthDir
   allIntfDir = entMan.allIntfDir

   allIntfStatusLocal = \
      Cell.root( entMan.root() )[ 'interface' ][ 'status' ][ 'local' ]

   # Create locally-mounted reactors under /ar/SysdbLag
   localRoot = entMan.root().parent

   # Create locally-mounted reactors under /ar/SysdbLag
   agent = localRoot.newEntity( "SysdbLag::Agent", "SysdbLag" )

   # Arnet and Ebra have stashed these here for us
   allIntfConfig = allIntfDir.config
   allIntfStatus = allIntfDir.status
   allEthConfig = allEthDir.config
   allEthStatus = allEthDir.status
   agent.lagConfigReactor = ( intfConfig, allEthConfig, allIntfConfig,
                              intfStatusLocal )
   agent.lagStatusReactor = ( intfStatus, allEthStatus, allIntfStatus )
   agent.lagStatusLocalDirReactor = ( intfStatusLocal,
                                      allIntfStatusLocal )
   # To avoid a circular reference, the active callback needs a weak
   # reference to the EntityManager.
   import weakref # pylint: disable=import-outside-toplevel
   entManRef = weakref.proxy( entMan )
   def handleActive( active ):
      if active:
         # LAG_ARCHER:
         # temporarily running these reactors to update interface/status/eth/lag
         # lag/status in Sysdb, until Cli is ready for AgentPlugin changes
         agent.lagStatusOutputSelector = ( lagInputIntf, intfStatus )
      else:
         # Note: this cleanup code is always a no-op except in testing.
         agent.lagStatusOutputSelector = None
   entMan.registerActiveCallback( handleActive )
