# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import functools
import os

NO_MEMOIZE_ENVVAR = "ARTOGGLES_NO_MEMOIZE"
TRACK_TOGGLE_USAGE = False
accessedToggles = set()

def enableToggleTracking( value ):
   global TRACK_TOGGLE_USAGE
   TRACK_TOGGLE_USAGE = value
   resetAccessedToggles()

def addAccessedToggles( toggleName ):
   if TRACK_TOGGLE_USAGE:
      accessedToggles.add( toggleName )

class ToggleCheckWithoutCallError( Exception ):
   pass

class ToggleWrapper:

   def __init__( self, toggleName, wrapped ):
      self.toggleName = toggleName
      self.wrapped = wrapped
      functools.update_wrapper( self, wrapped )
      self.memoizedResult_ = None

   def __call__( self ):
      addAccessedToggles( self.toggleName )
      if os.environ.get( NO_MEMOIZE_ENVVAR ) or self.memoizedResult_ is None:
         self.memoizedResult_ = self.wrapped()
      return self.memoizedResult_

   def __bool__( self ):
      raise ToggleCheckWithoutCallError( self.wrapped.__name__ +
         ' is a function, you should call it and test the result' )

   __nonzero__ = __bool__

def withToggle( toggleName ):
   return functools.partial( ToggleWrapper, toggleName )

def getAccessedToggles():
   return accessedToggles

def resetAccessedToggles():
   accessedToggles.clear()
