# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: rpmwith %{_bindir}/tpm_pcr_extend
# pkgdeps: rpmwith %{_bindir}/tpm_pcr_read
# pkgdeps: rpmwith %{_bindir}/tpm_sb_toggle

from enum import IntEnum
import hashlib

from TpmGeneric.Defs import Error, HashAlg, NoSBToggle
from TpmGeneric.Impl import TpmImpl

class TpmErrorCode( IntEnum ):
   BADINDEX = 0x2
   NOSPACE = 0x11

class Tpm12( TpmImpl ):
   TPM_VERSION_MAJOR_STRING = '1'
   PCR_HASH_ALGORITHM = HashAlg.SHA1

   def newPcrHash( self ):
      return hashlib.new( self.PCR_HASH_ALGORITHM.value )

   def pcrRead( self, pcrIndex ):
      cmd = [ 'tpm_pcr_read', hex( pcrIndex ) ]
      return self._runBinary( cmd ).splitlines()[ 0 ]

   def pcrExtend( self, pcrIndex, pcrHash ):
      cmd = [ 'tpm_pcr_extend', hex( pcrIndex ), pcrHash ]
      return self._runBinary( cmd ).splitlines()[ 0 ]

   def readSbToggle( self ):
      try:
         return int( self._runBinary( 'tpm_sb_toggle' ).rstrip(), 16 )
      except Error as e:
         if e.code in [ TpmErrorCode.BADINDEX, TpmErrorCode.NOSPACE ]:
            raise NoSBToggle()
         raise
