# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import os
import time

from .Defs import TPM_DATA_DIR

PCRLOG_FILE = os.path.join( TPM_DATA_DIR, 'pcr-extension.log' )
VERSION_NUMBER = 3

class PcrLog:
   def __init__( self, logFilePath=PCRLOG_FILE ):
      self.logFilePath = logFilePath

   def recordPcrExtension( self, pcrIndex, eventType, eventRev,
                           contentHash, annotations ):
      annotations = annotations or []

      if not os.path.isdir( TPM_DATA_DIR ):
         os.mkdir( TPM_DATA_DIR )

      try:
         with open( PCRLOG_FILE, 'a' ) as f:
            logEntryData = [
               str( VERSION_NUMBER ),
               str( int( time.time() ) ),
               str( int( pcrIndex ) ),
               hex( eventType ),
               contentHash ] + annotations + [ str( int( eventRev ) ) ]
            f.write( ' | '.join( logEntryData ) + '\n' )
      except OSError:
         pass
