#!/usr/bin/env python3
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import random
import Tac

routingHwStatus = Tac.newInstance( "Routing::Hardware::Status", "name" )
minTunnelIntfNum = 0
maxTunnelIntfNum = routingHwStatus.maxTunnelIntfNum - 1
tunnelDefaultMasklen = 24
tunnelDefaultTtl = 0
tunnelDefaultTos = 0
tunnelDefaultMtu = 0
tunnelDefaultKey = 0
tunnelDefaultMaxMss = 0

def minTunnelIndex( minIndex ):
   if  minIndex is None:
      return minTunnelIntfNum
   return minIndex

def maxTunnelIndex( maxIndex ):
   if  maxIndex is None:
      return maxTunnelIntfNum
   return maxIndex

# For all the utility functions below, the `index` to be
# specified in the optional arguments is the minimum and maximum
# tunnel interface numbers supported on the device, both values inclusive.
# Eg. If the number of supported tunnels is 256, the maxIndex
# can be atmost 255 as the interface numbering is 0 based.

def randomMiddleTunnelIndex( minIndex=None, maxIndex=None ):
   return random.randrange( minTunnelIndex( minIndex ) + 1,
                            maxTunnelIndex( maxIndex ) - 1 )

def randomLimitTunnelIndex( minIndex=None, maxIndex=None ):
   return random.choice( [ minTunnelIndex( minIndex ),
                           maxTunnelIndex( maxIndex ) ] )

def randomAnyTunnelIndex( minIndex=None, maxIndex=None ):
   return random.choice( [ minTunnelIndex( minIndex ),
                           maxTunnelIndex( maxIndex ),
                           randomMiddleTunnelIndex( minIndex, maxIndex ) ] )

def randomTunnelIndex( minIndex=None, maxIndex=None ):
   return randomLimitTunnelIndex( minIndex, maxIndex )

