# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from UrlPlugin.FlashUrl import FlashFilesystem
import Url
import os
import Toggles.StorageDevicesToggleLib as StorageDevicesToggles
import shutil
from StorageDevices import FileUtils

factoryResetCliEnabled = \
   StorageDevicesToggles.toggleStorageDevicesFactoryResetCliEnabled()

# class to register snapshot (user_recovery) filesystem
# needed in order to manipulate directory from CLI
class SnapshotFilesystem( FlashFilesystem ):

   def __init__( self, scheme, location ):
      super().__init__( scheme, location, fsType='snapshot' )

   # allows user to add, delete, and see files in directory
   def realFileSystem( self ):
      return True

   def fsRootIs( self, fsRoot ):
      FlashFilesystem.fsRootIs( self, fsRoot )
      snapshotDir = self.location_

      if not os.path.isdir( snapshotDir ):
         try:
            os.makedirs( snapshotDir )
         except OSError:
            pass

# --------------------------------------------------
# Plugin method - Mount the objects we need from Sysdb
# --------------------------------------------------
def Plugin( context=None ):
   # Register Snapshot as a filesytem with name: snapshot
   # location /mnt/flash/.user_recovery
   if factoryResetCliEnabled:
      Url.registerFilesystem( SnapshotFilesystem( FileUtils.snapshotFsName,
                                       f'flash/{FileUtils.snapshotFsLocation}' ) )
      # tmpRollbackDirPath and tmpRollbackDirPath2 used when copying snaphtot
      # through the CLI command reset system snapshot ... if device reboots
      # before command is finished, there is a chance we leave files in
      # tmpRollbackDirPath
      baseDir = os.environ.get( 'FILESYSTEM_ROOT', '/mnt' )
      tmpRollbackDirPath = os.path.join( baseDir, "flash",
         FileUtils.tmpSnapshotFsLocation )
      tmpRollbackDirPath2 = os.path.join( baseDir, "flash",
         FileUtils.tmpSnapshotFsLocation2 )
      if os.path.exists( tmpRollbackDirPath ):
         shutil.rmtree( tmpRollbackDirPath )
      if os.path.exists( tmpRollbackDirPath2 ):
         shutil.rmtree( tmpRollbackDirPath2 )
