# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Logging

DMF_CONTROLLER_HANDSHAKE_INIT = Logging.LogHandle(
   "DMF_CONTROLLER_HANDSHAKE_INIT",
   severity=Logging.logInfo,
   fmt="Initiating handshake with the DMF controller for provisioning the switch",
   explanation="DMF is configured. The switch is initiating a handshake with the "
               "DMF controller to become a member of the fabric.",
   recommendedAction=Logging.NO_ACTION_REQUIRED )

DMF_CONTROLLER_DOWNLOAD_FAILED = Logging.LogHandle(
   "DMF_CONTROLLER_DOWNLOAD_FAILED",
   severity=Logging.logError,
   fmt="Downloading %s from the DMF controller failed",
   explanation="The switch failed to download a file from the DMF controller. This "
               "led to failure of the handshake or syncing with the controller.",
   recommendedAction="Verify network reachability to the controller. The switch "
                     "will continue to retry downloading the file." )

DMF_CONTROLLER_FLASH_FULL = Logging.LogHandle(
   "DMF_CONTROLLER_FLASH_FULL",
   severity=Logging.logError,
   fmt="Insufficient space on flash to download image",
   explanation="Downloading image from the DMF controller failed. "
               "Please cleanup the flash manually.",
   recommendedAction="Please free space for the image in the flash manually." )

DMF_CONTROLLER_HANDSHAKE_FAILED = Logging.LogHandle(
   "DMF_CONTROLLER_HANDSHAKE_FAILED",
   severity=Logging.logError,
   fmt="The handshake with the controller failed because %s",
   explanation="The switch downloads and installs the startup-config and the image "
      "received from the controller as part of the initial handshake. If these "
      "actions fail, the switch will continue to run with the existing "
      "running-config but the controller will not have impact on the switch.",
   recommendedAction="Verify the version of the controller and the image "
      "provisioned on the controller for the switch. The switch and the "
      "controller will continue to try to complete the handshake with each other." )

DMF_CONTROLLER_HANDSHAKE_COMPLETE = Logging.LogHandle(
   "DMF_CONTROLLER_HANDSHAKE_COMPLETE",
   severity=Logging.logInfo,
   fmt="The handshake with the DMF controller completed",
   explanation="The switch was able to connect to the controller and is running "
      "with the config and image provisioned by the DMF controller.",
   recommendedAction=Logging.NO_ACTION_REQUIRED )

DMF_CONTROLLER_SYNC_START = Logging.LogHandle(
   "DMF_CONTROLLER_SYNC_START",
   severity=Logging.logInfo,
   fmt="Synchronizing the configuration and image with the controller started",
   explanation="The switch received a request from the controller to synchronize "
      "the config and the EOS image. It will download the config and image from the "
      "controller. If this operation does not complete in 90 seconds, serving the "
      "request will be aborted.",
   recommendedAction=Logging.NO_ACTION_REQUIRED )

DMF_CONTROLLER_SYNC_FAILED = Logging.LogHandle(
   "DMF_CONTROLLER_SYNC_FAILED",
   severity=Logging.logError,
   fmt="Synchronizing with the controller failed because %s",
   explanation="After downloading the config or image from the controller, the "
      "switch attempted to install it. The sync operation is determined as failed "
      " if the config contains invalid commands or if the image is invalid.",
   recommendedAction="Verify the version of the controller and the image "
      "provisioned on the controller for the switch." )

DMF_CONTROLLER_SYNC_TIMEOUT = Logging.LogHandle(
   "DMF_CONTROLLER_SYNC_TIMEOUT",
   severity=Logging.logError,
   fmt="Synchronizing the configuration and image with the controller timed out",
   explanation="After attempting to download the manifest, config or image and "
      "applying them, the switch has set the result of sync request as timed out.",
   recommendedAction="Verify network reachability to the controller and zerotouch "
      "status on the controllers." )

DMF_CONTROLLER_SYNC_COMPLETE = Logging.LogHandle(
   "DMF_CONTROLLER_SYNC_COMPLETE",
   severity=Logging.logInfo,
   fmt="Synchronization of the configuration and EOS image from the controller "
       "on the switch is complete",
   explanation="Upon receiving a request from the controller to resynchronize, the "
      "switch has downloaded the config and image from the controller and applied "
      "it successfully.",
   recommendedAction=Logging.NO_ACTION_REQUIRED )
