# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import

import ztn.settings

class ZtnmController:

    def __init__(self, addr, port=ztn.settings.ZTNM_DEFAULT_PORT,
                 ssl_or_protocol=True, timestamp=None):
        self.addr = addr
        self.port = port

        # These are to support some backwards compatibility
        if ssl_or_protocol in ztn.settings.ZTNM_ALLOWED_PROTOCOLS:
            self.protocol = ssl_or_protocol
        elif ssl_or_protocol is True:
            self.protocol = 'https'
        elif ssl_or_protocol is False:
            self.protocol = 'http'
        else:
            raise ValueError("%s is not a valid ssl_or_protocol argument." % ssl_or_protocol)

        self.timestamp = timestamp

    def __str__(self):
        return "ztn controller: addr=%s port=%d protocol=%s timestamp=%s" % (
               self.addr, self.port, self.protocol, self.timestamp)

    def prepare(self):
        pass
