"""Manifest.py

"""

import ztn.parser.manifest_v2 as v2
import ztn.parser.manifest_v3 as v3
import json


# With EOS and Appliances support version 3, it's the default
VERSION = 3

def fromJson(data):
    """Coerce JSON data into a manifest."""

    mver = data.get('ztn-version')
    if mver is None:
        return v2.Manifest.fromJson(data)

    if mver == 3:
        return v3.Manifest.fromJson(data)

    raise ValueError("Unsupported ZTN version parsed from JSON data: %s" % mver)

def getVersionFromKey(key):
    """Get the manifest version."""
    if key.startswith('SHA256:'):
        return 3
    if key.startswith('MD5:'):
        return 2
    raise ValueError("Unknown compute manifest version: %s" % key)

def fromChecksums(swiUrl=None,
                  swiChecksum=None,
                  configUrl=None,
                  configChecksum=None,
                  version=None):
    version = version or VERSION
    if version == 3:
        return v3.Manifest.fromChecksums(swiUrl=swiUrl,
                                                 swiChecksum=swiChecksum,
                                                 configUrl=configUrl,
                                                 configChecksum=configChecksum)
    if version == 2:
        return v2.Manifest.fromChecksums(swiUrl=swiUrl,
                                                 swiChecksum=swiChecksum,
                                                 configUrl=configUrl,
                                                 configChecksum=configChecksum)
    raise ValueError("invalid manifest version: %s" % version)
