# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#
# This is the default ZTN version to request.
#
# Only version 3 is supported in this module.
ZTNM_VERSION = 3

ZTNM_ALLOWED_VERSIONS_LIST = [3]

#
# The default management interface.
# The current architecture assumes knowledge related to this
# when processing zone_ids for link-local addresses.
#
# Fixing the assumption of a single management interface
# will require some thought and work.
#
ZTNM_MANAGEMENT_INTERFACE = 'ma1'

#
# The default MAC address used for transactions.
# If this value remains None then the mac address will
# be derived from the ZTNM_MANAGEMENT_INTERFACE
#
ZTNM_DEFAULT_MAC = None
#
# Allowed manifest request protocols
#
ZTNM_ALLOWED_PROTOCOLS = ['http', 'https']

#
# The default timeout for all http requests.
#
ZTNM_DEFAULT_HTTP_TIMEOUT_SEC = 5

# The manifest request port should properly come from
# the mdns or discovery endpoint. But until we have that
# sorted out we need to make an assumption.
ZTNM_DEFAULT_PORT = 8843

#
# Platform name.
#
ZTNM_PLATFORM_NAME = None

#
# Static target addresses can be specified here
#
ZTNM_STATIC_ADDRESSES = []

#
# Default logger
#
ZTNM_DEFAULT_LOGGER = None

#
# Additional parameters added to the manifest request url.
#
ZTNM_MANIFEST_REQUEST_ADD_PARAMS = []
