# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import

import json
import threading

from ztn.net.http import HttpRequestThread
from ztn.settings import ZTNM_DEFAULT_HTTP_TIMEOUT_SEC


class StartupConfigRequest(threading.Thread):

    def __init__(self, log):
        threading.Thread.__init__(self)
        self.log = log


    # pylint: disable=inconsistent-return-statements
    def get(self, url, timeout=ZTNM_DEFAULT_HTTP_TIMEOUT_SEC):
        response = HttpRequestThread(address=None,
                                     url=url,
                                     timeout=timeout,
                                     log=self.log).get()

        if response is None:
            return None

        if response.status_code == 200:
            try:
                return json.loads(response.text)
            except Exception as e:
                self.log.error("The content could not be parsed as json.\n  %s\n" % e)
                return None
        else:
            return None
