# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
# pylint: disable=import-error
import commands

def _show_counter_stat( cli, args, modName ):
   try:
      ret = cli.bess.run_module_command( modName,
                                         'getCounterStats',
                                         'ManagementCounterStatsArg', args )
   except Exception as error: # pylint: disable=broad-except
      # pylint: disable=no-member
      print( error.errmsg )
      return 0

   if args[ 'iter' ] == 0:
      cli.fout.write( 'BESS Counters statistics:\n' )
      cli.fout.write( f' counters in each block: {ret.counters_per_block}\n'
                      f' total blocks: {ret.max_blocks}\n'
                      f' blocks in use: {ret.inuse_blocks}\n'
                      f' counters in use: {ret.inuse_counters}\n'
                      f' memory used: {ret.memory_used} kB\n' )
      cli.fout.write( f"{'-'*60}\n" )
      cli.fout.write( ' blockId     '
                      ' counters-in-use     '
                      ' block-addr\n' )
      cli.fout.write( f"{'-'*60}\n" )

   for stat in ret.block_stats:
      cli.fout.write( f'    {stat.block_id:4d}'
                      f'                 {stat.block_ref_count:4d}'
                      f'      0x{stat.block_id_ptr:016X}\n' )
   return ret.next_iter

@commands.cmd( 'show counter stats', 'Show BESS generic counter statistics' )
def show_counter_statistics( cli ):
   mod = [ m.name for m in cli.bess.list_modules().modules
               if m.mclass == 'Management' ]
   if len( mod ) == 0:
      return
   args = {}
   args[ 'max_iterate' ] = 100
   args[ 'iter' ] = 0
   next_iter = 1

   while next_iter != 0:
      next_iter = _show_counter_stat( cli, args, mod[ 0 ] )
      args[ 'iter' ] = next_iter
   cli.fout.write( '\n' )
