# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import commands
import socket
import struct

def _show_classification_flow_info( cli, args, modName ):
   ret = cli.bess.run_module_command( modName,
                                      'getClassificationInfo',
                                      'GetClassificationInfoArg', args )
   for entry in ret.info:
      ipA = entry.fk.ip_a.ip_addr
      portA = socket.ntohs( entry.fk.port_a )
      ipB = entry.fk.ip_b.ip_addr
      portB = socket.ntohs( entry.fk.port_b )
      cli.fout.write( "vrfId %d ipA %s portA %d ipB %s portB %d protocol %d "
            "appProfileId %d appId %d appServiceId %d classified %d\n" %
         ( entry.fk.vrf_id, socket.inet_ntoa( struct.pack( '=L', ipA ) ), portA,
           socket.inet_ntoa( struct.pack( '=L', ipB ) ), portB, entry.fk.protocol,
           entry.app_profile_id, entry.app_id, entry.app_service_id,
           entry.classified, ) )
   return ret.next_iter

@commands.cmd( 'show classification-flow-info',
     'Show classification info for all flows' )
def show_classification_flow_info( cli ):
   mod = [ m.name for m in cli.bess.list_modules().modules
               if m.mclass == 'Classification' ]
   if len( mod ) == 0:
      return
   args = {}
   args[ 'max_iterate' ] = 100
   args[ 'iter' ] = 0
   next_iter = 1

   while next_iter != 0:
      next_iter = _show_classification_flow_info( cli, args, mod[ 0 ] )
      args[ 'iter' ] = next_iter
   cli.fout.write( '\n' )
