# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import commands
from cli_parser.option_parser import OptionParser

class ShowDefragOptionParser( OptionParser ):

   def register_options( self ):
      self.add_option( "-h", "action", action=self.help )

   @staticmethod
   def help():
      help_text = [
         "Usage:",
         " show ip defrag-table stats [OPTIONS]",
         "",
         "Options:",
         " -h\t\t\thelp"
         ]
      print( "\n".join( help_text ) )

def _show_defrag_parse_options( cli, opts ):
   if opts is None:
      opts = []
   try:
      parser = ShowDefragOptionParser( opts )
      parser.parse()
   # pylint: disable=broad-except
   except Exception as error:
      cli.CommandError( error )

@commands.cmd( 'show ip defrag-table stats -h',
      'show ip defrag-table stats help' )
def show_defrag_help( cli ):
   opts = [ '-h' ]
   _show_defrag_parse_options( cli, opts )

@commands.cmd( 'show ip defrag-table stats',
     'show ip defrag-table stats: display defrag-table stats' )
def show_defrag_table_stats( cli ):
   forUs = [ m.name for m in cli.bess.list_modules().modules
               if m.mclass == 'ForUsClassifyIpv4' ]
   if len( forUs ) == 0:
      return
   ret = cli.bess.run_module_command(
         forUs[ 0 ], 'getArIpDefragStats', 'EmptyArg', {} )
   cli.fout.write( ret.defrag_stats )
   cli.fout.write( '\n' )
