# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import commands

@commands.cmd( 'show ip4gretunencap TUNID',
      'Show gre tunnel encap entries for a given tunnel id' )
def show_ip4gretunencap( cli, tunid ):
   if not tunid:
      raise cli.CommandError( 'No tunnel id specified' )

   ret = cli.bess.run_module_command( 'Ip4GreTun_tun' + str( tunid ),
                                      'showIp4TunEncap', 'EmptyArg', {} )
   cli.fout.write( 'show ip4gretunencap response: %s\n' % repr( ret ) )

@commands.var_attrs( 'TUNID' )
def tunid_var_attrs():
   # Return (var_type(str), var_desc(str), var_candidates([str]))
   return ( 'int', '', [] )
