# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import commands

@commands.cmd( 'show ip4tundemux [TUNID]',
      'Show all tunnel demux entries or for a given tunnel id' )
def show_ip4tundemux( cli, tunid ):
   args = {}
   if tunid:
      args[ 'tun_id' ] = tunid
   ret = cli.bess.run_module_command( 'Ip4TunDemux', 'showIp4TunDemux',
                                      'Ip4TunDemuxDecapShowArg', args )
   cli.fout.write( 'show ip4tundemux response: %s\n' % repr( ret ) )

@commands.cmd( 'show ip4tundemux pktdrops',
      'Show tunnel decap packet drop counters' )
def show_ip4tundecap( cli ):
   ret = cli.bess.run_module_command( 'Ip4TunDemux', 'getIp4TunDemuxDropCounters',
                                      'EmptyArg', {} )
   cli.fout.write( 'show ip4tundemux pktdrops response: %s\n' % repr( ret ) )

@commands.var_attrs( '[TUNID]' )
def tunid_opt_var_attrs():
   # Return (var_type(str), var_desc(str), var_candidates([str]))
   return ( 'int', '', [] )
