# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import commands

@commands.cmd( 'show nexthop entries NHMODULE...', 'display the nexthop entries' )
def show_nh_entries( cli, module_names ):
   if module_names[ 0 ] == '*':
      module_names = [ m.name for m in cli.bess.list_modules().modules
                          if 'NextHop' in m.mclass ]
   for nhMod in module_names:
      # get the nh entries
      ret = cli.bess.run_module_command( nhMod, 'showNH', 'NextHopShowArg', {} )
      cli.fout.write( '%s\n' % ret.intfName )
      for nhInfo in sorted( ret.nextHopInfo, key=lambda x: x.nh_index ):
         cli.fout.write( '  nh %2d mac %s vlan %d pkt_cmd %d\n' %
               ( nhInfo.nh_index, nhInfo.mac_da, nhInfo.vlan, nhInfo.pkt_cmd ) )

def nh_module_candidates( cli ):
   var_candidates = [ '*' ]
   try:
      var_candidates += [ m.name for m in cli.bess.list_modules().modules
          if 'NextHop' in m.mclass ]
   except:
      pass
   return var_candidates

@commands.var_attrs( 'NHMODULE...' )
def nh_module_var_attrs():
   # Return (var_type(str), var_desc(str), var_candidates(func))
   return ( 'name+', 'one or more module names of mclass NextHop (* means all)',
      nh_module_candidates )
