# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import commands
import socket
import struct

def _show_offload_info_stats( cli, args, modName ):
   ret = cli.bess.run_module_command( modName,
                                      'getOffloadInfo',
                                      'GetOffloadInfoArg', args )
   for entry in ret.info:
      ipA = entry.fk.ip_a.ip_addr
      portA = socket.ntohs( entry.fk.port_a )
      ipB = entry.fk.ip_b.ip_addr
      portB = socket.ntohs( entry.fk.port_b )
      cli.fout.write( "workerId %d: npkts %d deltaSecs %d vrfId %d "
         "ipA %s portA %d ipB %s portB %d protocol %d\n" %
         ( entry.wid, entry.npkts, entry.deltasecs, entry.fk.vrf_id,
           socket.inet_ntoa( struct.pack( '=L', ipA ) ), portA,
           socket.inet_ntoa( struct.pack( '=L', ipB ) ), portB,
           entry.fk.protocol ) )
   return ret.next_iter

@commands.cmd( 'show offload-info-stats',
     'show offload info stats: display all flows that have been offloaded' )
def show_offload_info_stats( cli ):
   mod = [ m.name for m in cli.bess.list_modules().modules
               if m.mclass == 'IpsecTunnelIngress' ]
   if len( mod ) == 0:
      return
   args = {}
   args[ 'max_iterate' ] = 100
   args[ 'iter' ] = 0
   next_iter = 1
   cli.fout.write( 'show offload-info-stats:\n' )
   while next_iter != 0:
      next_iter = _show_offload_info_stats( cli, args, mod[ 0 ] )
      args[ 'iter' ] = next_iter
   cli.fout.write( '\n' )
