# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import commands
from internetExit import show_internet_exit_counters

def getSiEdgeModName( cli ):
   for m in cli.bess.list_modules().modules:
      if m.mclass == 'SiEdge':
         return m.name
   return None

def show_si_edge_counters_header( cli ):
   cli.fout.write( "Service Insertion Edge Counters:\n" )
   cli.fout.write( "--------------------------------\n" )

def show_si_edge_counters( cli, stats ):
   cli.fout.write(
     "No of AVT id lookup failures : %d\n" % stats.avt_id_lookup_fail_cnt )
   cli.fout.write( '\n' )

@commands.cmd( 'show service-insertion edge counters',
     'Show service insertion edge counters' )
def show_si_edge_counters_cmd( cli ):
   modName = getSiEdgeModName( cli )
   if not modName:
      return
   show_si_edge_counters_header( cli )
   stats = cli.bess.run_module_command( modName, 'getCounters', 'EmptyArg', {} )
   show_internet_exit_counters( cli, stats )
   stats = cli.bess.run_module_command( modName, 'getEdgeCounters', 'EmptyArg', {} )
   show_si_edge_counters( cli, stats )
