# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
from .string_validator import StringValidator
from .uint_validator import UintValidator

class OptionValidatorFactory(object):
   @staticmethod
   def create(type_):
      if type_ == "string":
         return StringValidator()
      elif type_ == "uint":
         return UintValidator()
      else:
         raise Exception("Invalid option validator name passed")
