# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
from .option_validator import OptionValidator

class UintValidator(OptionValidator):

   def __init__(self):
      OptionValidator.__init__(self)
      self.value = -1
      self.pos = 0

   def run(self):
      self.pos += 1
      if self.pos < len(self.params):
         self.value = int(self.params[self.pos])
         self.pos += 1
      if self.value >= 0:
         return
      raise Exception("uint parsing error")

