# 

dir=$(dirname "$0")

export PATH="$(pwd)/tests/bin":$PATH

. "$dir"/test-lib.sh

setup

desc 'setup.py without arguments'
fails '/usr/bin/python3 setup.py'
succeeds '/usr/bin/python3 setup.py 2>&1 |grep "usage: setup.py"'

desc 'setup.py --help'
succeeds '/usr/bin/python3 setup.py --help'
# .* = Unix|Windows
succeeds '/usr/bin/python3 setup.py --help |grep "PycURL .* options:"'
# distutils help
succeeds '/usr/bin/python3 setup.py --help |grep "Common commands:"'

desc 'setup.py --help with bogus --curl-config'
succeeds '/usr/bin/python3 setup.py --help --curl-config=/dev/null'
succeeds '/usr/bin/python3 setup.py --help --curl-config=/dev/null |grep "PycURL .* options:"'
# this checks that --curl-config is consumed prior to
# distutils processing --help
fails '/usr/bin/python3 setup.py --help --curl-config=/dev/null 2>&1 |grep "option .* not recognized"'
