// Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
// Arista Networks, Inc. Confidential and Proprietary.
// Subject to Arista Networks, Inc.'s EULA.
// FOR INTERNAL USE ONLY. NOT FOR DISTRIBUTION.

//
// Code generated by boomtown. DO NOT EDIT.
//

package segmentation

import "google.golang.org/grpc"

// Client composes the service clients within the segmentation package.
// This client can then be composed into a larger hierarchy for more complex clients.
//
// Because method names include the name of the Resource they operate on, the embedded
// clients are unnamed fields to reduce stutter.
//
// Included resources:
//   - ApplicationConfig
//   - DefaultActionConfig
//   - Domain
//   - DomainConfig
//   - DomainIPPrefixConfig
//   - DomainSegmentConfig
//   - DomainSegmentPolicy
//   - DomainSegmentPolicyConfig
//   - PolicyConfig
type Client struct {
	ApplicationConfig         ApplicationConfigServiceClient
	DefaultActionConfig       DefaultActionConfigServiceClient
	Domain                    DomainServiceClient
	DomainConfig              DomainConfigServiceClient
	DomainIPPrefixConfig      DomainIPPrefixConfigServiceClient
	DomainSegmentConfig       DomainSegmentConfigServiceClient
	DomainSegmentPolicy       DomainSegmentPolicyServiceClient
	DomainSegmentPolicyConfig DomainSegmentPolicyConfigServiceClient
	PolicyConfig              PolicyConfigServiceClient
}

// NewClient creates a new composed-client from the given connection.
func NewClient(conn grpc.ClientConnInterface) Client {
	return Client{
		ApplicationConfig:         NewApplicationConfigServiceClient(conn),
		DefaultActionConfig:       NewDefaultActionConfigServiceClient(conn),
		Domain:                    NewDomainServiceClient(conn),
		DomainConfig:              NewDomainConfigServiceClient(conn),
		DomainIPPrefixConfig:      NewDomainIPPrefixConfigServiceClient(conn),
		DomainSegmentConfig:       NewDomainSegmentConfigServiceClient(conn),
		DomainSegmentPolicy:       NewDomainSegmentPolicyServiceClient(conn),
		DomainSegmentPolicyConfig: NewDomainSegmentPolicyConfigServiceClient(conn),
		PolicyConfig:              NewPolicyConfigServiceClient(conn),
	}
}

// Server aggregates the various server interfaces required by gRPC.
// The included resources are:
//   - ApplicationConfig
//   - DefaultActionConfig
//   - Domain
//   - DomainConfig
//   - DomainIPPrefixConfig
//   - DomainSegmentConfig
//   - DomainSegmentPolicy
//   - DomainSegmentPolicyConfig
//   - PolicyConfig
type Server struct {
	ApplicationConfig         ApplicationConfigServiceServer
	DefaultActionConfig       DefaultActionConfigServiceServer
	Domain                    DomainServiceServer
	DomainConfig              DomainConfigServiceServer
	DomainIPPrefixConfig      DomainIPPrefixConfigServiceServer
	DomainSegmentConfig       DomainSegmentConfigServiceServer
	DomainSegmentPolicy       DomainSegmentPolicyServiceServer
	DomainSegmentPolicyConfig DomainSegmentPolicyConfigServiceServer
	PolicyConfig              PolicyConfigServiceServer
}

// Register takes the given gRPC Server and registers our services with it.
func (s Server) Register(target *grpc.Server) {
	RegisterApplicationConfigServiceServer(target, s.ApplicationConfig)
	RegisterDefaultActionConfigServiceServer(target, s.DefaultActionConfig)
	RegisterDomainServiceServer(target, s.Domain)
	RegisterDomainConfigServiceServer(target, s.DomainConfig)
	RegisterDomainIPPrefixConfigServiceServer(target, s.DomainIPPrefixConfig)
	RegisterDomainSegmentConfigServiceServer(target, s.DomainSegmentConfig)
	RegisterDomainSegmentPolicyServiceServer(target, s.DomainSegmentPolicy)
	RegisterDomainSegmentPolicyConfigServiceServer(target, s.DomainSegmentPolicyConfig)
	RegisterPolicyConfigServiceServer(target, s.PolicyConfig)
}

// RegisterUnimplementeds adds unimplemented servers to the given gRPC Server
func RegisterUnimplementeds(target *grpc.Server) error {
	RegisterApplicationConfigServiceServer(target,
		UnimplementedApplicationConfigServiceServer{})
	RegisterDefaultActionConfigServiceServer(target,
		UnimplementedDefaultActionConfigServiceServer{})
	RegisterDomainServiceServer(target,
		UnimplementedDomainServiceServer{})
	RegisterDomainConfigServiceServer(target,
		UnimplementedDomainConfigServiceServer{})
	RegisterDomainIPPrefixConfigServiceServer(target,
		UnimplementedDomainIPPrefixConfigServiceServer{})
	RegisterDomainSegmentConfigServiceServer(target,
		UnimplementedDomainSegmentConfigServiceServer{})
	RegisterDomainSegmentPolicyServiceServer(target,
		UnimplementedDomainSegmentPolicyServiceServer{})
	RegisterDomainSegmentPolicyConfigServiceServer(target,
		UnimplementedDomainSegmentPolicyConfigServiceServer{})
	RegisterPolicyConfigServiceServer(target,
		UnimplementedPolicyConfigServiceServer{})
	return nil
}

// HasKey returns whether the given ApplicationConfig has a key provided in the model.
func (a *ApplicationConfig) HasKey() bool {
	return a.GetKey() != nil
}

// HasKey returns whether the given ApplicationConfigRequest has a key provided in the request.
func (a *ApplicationConfigRequest) HasKey() bool {
	return a.GetKey() != nil
}

// HasKey returns whether the given ApplicationConfigSetRequest has a key provided in the request.
func (a *ApplicationConfigSetRequest) HasKey() bool {
	return a.GetValue().HasKey()
}

// HasKey returns whether the given ApplicationConfigDeleteRequest has a key provided in the request.
func (a *ApplicationConfigDeleteRequest) HasKey() bool {
	return a.GetKey() != nil
}

// HasKey returns whether the given Domain has a key provided in the model.
func (d *Domain) HasKey() bool {
	return d.GetKey() != nil
}

// HasKey returns whether the given DomainRequest has a key provided in the request.
func (d *DomainRequest) HasKey() bool {
	return d.GetKey() != nil
}

// HasKey returns whether the given DomainConfig has a key provided in the model.
func (d *DomainConfig) HasKey() bool {
	return d.GetKey() != nil
}

// HasKey returns whether the given DomainConfigRequest has a key provided in the request.
func (d *DomainConfigRequest) HasKey() bool {
	return d.GetKey() != nil
}

// HasKey returns whether the given DomainConfigSetRequest has a key provided in the request.
func (d *DomainConfigSetRequest) HasKey() bool {
	return d.GetValue().HasKey()
}

// HasKey returns whether the given DomainConfigDeleteRequest has a key provided in the request.
func (d *DomainConfigDeleteRequest) HasKey() bool {
	return d.GetKey() != nil
}

// HasKey returns whether the given DomainIPPrefixConfig has a key provided in the model.
func (d *DomainIPPrefixConfig) HasKey() bool {
	return d.GetKey() != nil
}

// HasKey returns whether the given DomainIPPrefixConfigRequest has a key provided in the request.
func (d *DomainIPPrefixConfigRequest) HasKey() bool {
	return d.GetKey() != nil
}

// HasKey returns whether the given DomainIPPrefixConfigSetRequest has a key provided in the request.
func (d *DomainIPPrefixConfigSetRequest) HasKey() bool {
	return d.GetValue().HasKey()
}

// HasKey returns whether the given DomainIPPrefixConfigDeleteRequest has a key provided in the request.
func (d *DomainIPPrefixConfigDeleteRequest) HasKey() bool {
	return d.GetKey() != nil
}

// HasKey returns whether the given DomainSegmentConfig has a key provided in the model.
func (d *DomainSegmentConfig) HasKey() bool {
	return d.GetKey() != nil
}

// HasKey returns whether the given DomainSegmentConfigRequest has a key provided in the request.
func (d *DomainSegmentConfigRequest) HasKey() bool {
	return d.GetKey() != nil
}

// HasKey returns whether the given DomainSegmentConfigSetRequest has a key provided in the request.
func (d *DomainSegmentConfigSetRequest) HasKey() bool {
	return d.GetValue().HasKey()
}

// HasKey returns whether the given DomainSegmentConfigDeleteRequest has a key provided in the request.
func (d *DomainSegmentConfigDeleteRequest) HasKey() bool {
	return d.GetKey() != nil
}

// HasKey returns whether the given DomainSegmentPolicy has a key provided in the model.
func (d *DomainSegmentPolicy) HasKey() bool {
	return d.GetKey() != nil
}

// HasKey returns whether the given DomainSegmentPolicyRequest has a key provided in the request.
func (d *DomainSegmentPolicyRequest) HasKey() bool {
	return d.GetKey() != nil
}

// HasKey returns whether the given DomainSegmentPolicyConfig has a key provided in the model.
func (d *DomainSegmentPolicyConfig) HasKey() bool {
	return d.GetKey() != nil
}

// HasKey returns whether the given DomainSegmentPolicyConfigRequest has a key provided in the request.
func (d *DomainSegmentPolicyConfigRequest) HasKey() bool {
	return d.GetKey() != nil
}

// HasKey returns whether the given DomainSegmentPolicyConfigSetRequest has a key provided in the request.
func (d *DomainSegmentPolicyConfigSetRequest) HasKey() bool {
	return d.GetValue().HasKey()
}

// HasKey returns whether the given DomainSegmentPolicyConfigDeleteRequest has a key provided in the request.
func (d *DomainSegmentPolicyConfigDeleteRequest) HasKey() bool {
	return d.GetKey() != nil
}

// HasKey returns whether the given PolicyConfig has a key provided in the model.
func (p *PolicyConfig) HasKey() bool {
	return p.GetKey() != nil
}

// HasKey returns whether the given PolicyConfigRequest has a key provided in the request.
func (p *PolicyConfigRequest) HasKey() bool {
	return p.GetKey() != nil
}

// HasKey returns whether the given PolicyConfigSetRequest has a key provided in the request.
func (p *PolicyConfigSetRequest) HasKey() bool {
	return p.GetValue().HasKey()
}

// HasKey returns whether the given PolicyConfigDeleteRequest has a key provided in the request.
func (p *PolicyConfigDeleteRequest) HasKey() bool {
	return p.GetKey() != nil
}

// PassesPartialEqFilter returns whether this Action matches the comparison. If the given
// argument is unitialized, it is considered a match.
func (a Action) PassesPartialEqFilter(cmp Action) bool {
	if cmp != Action(0) {
		return a == cmp
	}
	return true
}

// PassesPartialEqFilter returns whether the ApplicationAction matches the passed in filter.
// On a nil comparison, we consider it a pass. Otherwise, all set (non-nil, initialized)
// fields are expected to match their "sibling" field in the comparison. Any non-matching
// value is considered a mismatch of the filter.
func (a *ApplicationAction) PassesPartialEqFilter(cmp *ApplicationAction) bool {
	// gave nothing to filter on, consider it passing
	if cmp == nil {
		return true
	}

	if a == nil {
		return false
	}
	if len(cmp.Values) > len(a.Values) {
		return false
	}
	for k, filt := range cmp.Values {
		self, exists := a.Values[k]
		if !exists || !self.PassesPartialEqFilter(filt) {
			return false
		}
	}

	return true
}

// PassesPartialEqFilter returns whether the ApplicationList matches the passed in filter.
// On a nil comparison, we consider it a pass. Otherwise, all set (non-nil, initialized)
// fields are expected to match their "sibling" field in the comparison. Any non-matching
// value is considered a mismatch of the filter.
func (a *ApplicationList) PassesPartialEqFilter(cmp *ApplicationList) bool {
	// gave nothing to filter on, consider it passing
	if cmp == nil {
		return true
	}

	if a == nil {
		return false
	}
	if len(a.Values) != len(cmp.Values) {
		return false
	}
	for i, f := range a.Values {
		if cmp.Values[i] != f {
			return false
		}
	}

	return true
}

// PassesPartialEqFilter returns whether the IPPrefixConfig matches the passed in filter.
// On a nil comparison, we consider it a pass. Otherwise, all set (non-nil, initialized)
// fields are expected to match their "sibling" field in the comparison. Any non-matching
// value is considered a mismatch of the filter.
func (i *IPPrefixConfig) PassesPartialEqFilter(cmp *IPPrefixConfig) bool {
	// gave nothing to filter on, consider it passing
	if cmp == nil {
		return true
	}

	if i == nil {
		return false
	}
	if !i.Key.PassesPartialEqFilter(cmp.Key) {
		return false
	}

	if cmp.Segment != nil {
		if i.Segment == nil {
			return false
		}
		if i.Segment.Value != cmp.Segment.Value {
			return false
		}
	}

	return true
}

// PassesPartialEqFilter returns whether the IPPrefixConfigList matches the passed in filter.
// On a nil comparison, we consider it a pass. Otherwise, all set (non-nil, initialized)
// fields are expected to match their "sibling" field in the comparison. Any non-matching
// value is considered a mismatch of the filter.
func (i *IPPrefixConfigList) PassesPartialEqFilter(cmp *IPPrefixConfigList) bool {
	// gave nothing to filter on, consider it passing
	if cmp == nil {
		return true
	}

	if i == nil {
		return false
	}
	if len(i.Values) != len(cmp.Values) {
		return false
	}
	for i, f := range i.Values {
		if !f.PassesPartialEqFilter(cmp.Values[i]) {
			return false
		}
	}

	return true
}

// PassesPartialEqFilter returns whether the SegmentConfig matches the passed in filter.
// On a nil comparison, we consider it a pass. Otherwise, all set (non-nil, initialized)
// fields are expected to match their "sibling" field in the comparison. Any non-matching
// value is considered a mismatch of the filter.
func (s *SegmentConfig) PassesPartialEqFilter(cmp *SegmentConfig) bool {
	// gave nothing to filter on, consider it passing
	if cmp == nil {
		return true
	}

	if s == nil {
		return false
	}
	if !s.Key.PassesPartialEqFilter(cmp.Key) {
		return false
	}

	return true
}

// PassesPartialEqFilter returns whether the SegmentConfigList matches the passed in filter.
// On a nil comparison, we consider it a pass. Otherwise, all set (non-nil, initialized)
// fields are expected to match their "sibling" field in the comparison. Any non-matching
// value is considered a mismatch of the filter.
func (s *SegmentConfigList) PassesPartialEqFilter(cmp *SegmentConfigList) bool {
	// gave nothing to filter on, consider it passing
	if cmp == nil {
		return true
	}

	if s == nil {
		return false
	}
	if len(s.Values) != len(cmp.Values) {
		return false
	}
	for i, f := range s.Values {
		if !f.PassesPartialEqFilter(cmp.Values[i]) {
			return false
		}
	}

	return true
}

// PassesPartialEqFilter returns whether the SegmentPolicy matches the passed in filter.
// On a nil comparison, we consider it a pass. Otherwise, all set (non-nil, initialized)
// fields are expected to match their "sibling" field in the comparison. Any non-matching
// value is considered a mismatch of the filter.
func (s *SegmentPolicy) PassesPartialEqFilter(cmp *SegmentPolicy) bool {
	// gave nothing to filter on, consider it passing
	if cmp == nil {
		return true
	}

	if s == nil {
		return false
	}
	if !s.Key.PassesPartialEqFilter(cmp.Key) {
		return false
	}
	if !s.Counters.PassesPartialEqFilter(cmp.Counters) {
		return false
	}

	return true
}

// PassesPartialEqFilter returns whether the SegmentPolicyConfig matches the passed in filter.
// On a nil comparison, we consider it a pass. Otherwise, all set (non-nil, initialized)
// fields are expected to match their "sibling" field in the comparison. Any non-matching
// value is considered a mismatch of the filter.
func (s *SegmentPolicyConfig) PassesPartialEqFilter(cmp *SegmentPolicyConfig) bool {
	// gave nothing to filter on, consider it passing
	if cmp == nil {
		return true
	}

	if s == nil {
		return false
	}
	if !s.Key.PassesPartialEqFilter(cmp.Key) {
		return false
	}

	if cmp.Policy != nil {
		if s.Policy == nil {
			return false
		}
		if s.Policy.Value != cmp.Policy.Value {
			return false
		}
	}

	return true
}

// PassesPartialEqFilter returns whether the SegmentPolicyConfigList matches the passed in filter.
// On a nil comparison, we consider it a pass. Otherwise, all set (non-nil, initialized)
// fields are expected to match their "sibling" field in the comparison. Any non-matching
// value is considered a mismatch of the filter.
func (s *SegmentPolicyConfigList) PassesPartialEqFilter(cmp *SegmentPolicyConfigList) bool {
	// gave nothing to filter on, consider it passing
	if cmp == nil {
		return true
	}

	if s == nil {
		return false
	}
	if len(s.Values) != len(cmp.Values) {
		return false
	}
	for i, f := range s.Values {
		if !f.PassesPartialEqFilter(cmp.Values[i]) {
			return false
		}
	}

	return true
}

// PassesPartialEqFilter returns whether the SegmentPolicyCounters matches the passed in filter.
// On a nil comparison, we consider it a pass. Otherwise, all set (non-nil, initialized)
// fields are expected to match their "sibling" field in the comparison. Any non-matching
// value is considered a mismatch of the filter.
func (s *SegmentPolicyCounters) PassesPartialEqFilter(cmp *SegmentPolicyCounters) bool {
	// gave nothing to filter on, consider it passing
	if cmp == nil {
		return true
	}

	if s == nil {
		return false
	}

	if cmp.Hits != nil {
		if s.Hits == nil {
			return false
		}
		if s.Hits.Value != cmp.Hits.Value {
			return false
		}
	}

	if cmp.Drops != nil {
		if s.Drops == nil {
			return false
		}
		if s.Drops.Value != cmp.Drops.Value {
			return false
		}
	}

	return true
}

// PassesPartialEqFilter returns whether the SegmentPolicyList matches the passed in filter.
// On a nil comparison, we consider it a pass. Otherwise, all set (non-nil, initialized)
// fields are expected to match their "sibling" field in the comparison. Any non-matching
// value is considered a mismatch of the filter.
func (s *SegmentPolicyList) PassesPartialEqFilter(cmp *SegmentPolicyList) bool {
	// gave nothing to filter on, consider it passing
	if cmp == nil {
		return true
	}

	if s == nil {
		return false
	}
	if len(s.Values) != len(cmp.Values) {
		return false
	}
	for i, f := range s.Values {
		if !f.PassesPartialEqFilter(cmp.Values[i]) {
			return false
		}
	}

	return true
}

// PassesPartialEqFilter returns whether the ApplicationKey matches the passed in filter.
// On a nil comparison, we consider it a pass. Otherwise, all set (non-nil, initialized)
// fields are expected to match their "sibling" field in the comparison. Any non-matching
// value is considered a mismatch of the filter.
func (a *ApplicationKey) PassesPartialEqFilter(cmp *ApplicationKey) bool {
	// gave nothing to filter on, consider it passing
	if cmp == nil {
		return true
	}

	if a == nil {
		return false
	}

	if cmp.Application != nil {
		if a.Application == nil {
			return false
		}
		if a.Application.Value != cmp.Application.Value {
			return false
		}
	}

	return true
}

// PassesPartialEqFilter returns whether the DomainIPPrefixKey matches the passed in filter.
// On a nil comparison, we consider it a pass. Otherwise, all set (non-nil, initialized)
// fields are expected to match their "sibling" field in the comparison. Any non-matching
// value is considered a mismatch of the filter.
func (d *DomainIPPrefixKey) PassesPartialEqFilter(cmp *DomainIPPrefixKey) bool {
	// gave nothing to filter on, consider it passing
	if cmp == nil {
		return true
	}

	if d == nil {
		return false
	}

	if cmp.Domain != nil {
		if d.Domain == nil {
			return false
		}
		if d.Domain.Value != cmp.Domain.Value {
			return false
		}
	}

	if cmp.Vrf != nil {
		if d.Vrf == nil {
			return false
		}
		if d.Vrf.Value != cmp.Vrf.Value {
			return false
		}
	}

	if cmp.IpPrefix != nil {
		if d.IpPrefix == nil {
			return false
		}
		if d.IpPrefix.Value != cmp.IpPrefix.Value {
			return false
		}
	}

	return true
}

// PassesPartialEqFilter returns whether the DomainKey matches the passed in filter.
// On a nil comparison, we consider it a pass. Otherwise, all set (non-nil, initialized)
// fields are expected to match their "sibling" field in the comparison. Any non-matching
// value is considered a mismatch of the filter.
func (d *DomainKey) PassesPartialEqFilter(cmp *DomainKey) bool {
	// gave nothing to filter on, consider it passing
	if cmp == nil {
		return true
	}

	if d == nil {
		return false
	}

	if cmp.Domain != nil {
		if d.Domain == nil {
			return false
		}
		if d.Domain.Value != cmp.Domain.Value {
			return false
		}
	}

	if cmp.Vrf != nil {
		if d.Vrf == nil {
			return false
		}
		if d.Vrf.Value != cmp.Vrf.Value {
			return false
		}
	}

	return true
}

// PassesPartialEqFilter returns whether the DomainSegmentKey matches the passed in filter.
// On a nil comparison, we consider it a pass. Otherwise, all set (non-nil, initialized)
// fields are expected to match their "sibling" field in the comparison. Any non-matching
// value is considered a mismatch of the filter.
func (d *DomainSegmentKey) PassesPartialEqFilter(cmp *DomainSegmentKey) bool {
	// gave nothing to filter on, consider it passing
	if cmp == nil {
		return true
	}

	if d == nil {
		return false
	}

	if cmp.Domain != nil {
		if d.Domain == nil {
			return false
		}
		if d.Domain.Value != cmp.Domain.Value {
			return false
		}
	}

	if cmp.Vrf != nil {
		if d.Vrf == nil {
			return false
		}
		if d.Vrf.Value != cmp.Vrf.Value {
			return false
		}
	}

	if cmp.Segment != nil {
		if d.Segment == nil {
			return false
		}
		if d.Segment.Value != cmp.Segment.Value {
			return false
		}
	}

	return true
}

// PassesPartialEqFilter returns whether the DomainSegmentPolicyKey matches the passed in filter.
// On a nil comparison, we consider it a pass. Otherwise, all set (non-nil, initialized)
// fields are expected to match their "sibling" field in the comparison. Any non-matching
// value is considered a mismatch of the filter.
func (d *DomainSegmentPolicyKey) PassesPartialEqFilter(cmp *DomainSegmentPolicyKey) bool {
	// gave nothing to filter on, consider it passing
	if cmp == nil {
		return true
	}

	if d == nil {
		return false
	}

	if cmp.Domain != nil {
		if d.Domain == nil {
			return false
		}
		if d.Domain.Value != cmp.Domain.Value {
			return false
		}
	}

	if cmp.Vrf != nil {
		if d.Vrf == nil {
			return false
		}
		if d.Vrf.Value != cmp.Vrf.Value {
			return false
		}
	}

	if cmp.SrcSegment != nil {
		if d.SrcSegment == nil {
			return false
		}
		if d.SrcSegment.Value != cmp.SrcSegment.Value {
			return false
		}
	}

	if cmp.DstSegment != nil {
		if d.DstSegment == nil {
			return false
		}
		if d.DstSegment.Value != cmp.DstSegment.Value {
			return false
		}
	}

	return true
}

// PassesPartialEqFilter returns whether the IPPrefixKey matches the passed in filter.
// On a nil comparison, we consider it a pass. Otherwise, all set (non-nil, initialized)
// fields are expected to match their "sibling" field in the comparison. Any non-matching
// value is considered a mismatch of the filter.
func (i *IPPrefixKey) PassesPartialEqFilter(cmp *IPPrefixKey) bool {
	// gave nothing to filter on, consider it passing
	if cmp == nil {
		return true
	}

	if i == nil {
		return false
	}

	if cmp.IpPrefix != nil {
		if i.IpPrefix == nil {
			return false
		}
		if i.IpPrefix.Value != cmp.IpPrefix.Value {
			return false
		}
	}

	return true
}

// PassesPartialEqFilter returns whether the PolicyKey matches the passed in filter.
// On a nil comparison, we consider it a pass. Otherwise, all set (non-nil, initialized)
// fields are expected to match their "sibling" field in the comparison. Any non-matching
// value is considered a mismatch of the filter.
func (p *PolicyKey) PassesPartialEqFilter(cmp *PolicyKey) bool {
	// gave nothing to filter on, consider it passing
	if cmp == nil {
		return true
	}

	if p == nil {
		return false
	}

	if cmp.Policy != nil {
		if p.Policy == nil {
			return false
		}
		if p.Policy.Value != cmp.Policy.Value {
			return false
		}
	}

	return true
}

// PassesPartialEqFilter returns whether the SegmentKey matches the passed in filter.
// On a nil comparison, we consider it a pass. Otherwise, all set (non-nil, initialized)
// fields are expected to match their "sibling" field in the comparison. Any non-matching
// value is considered a mismatch of the filter.
func (s *SegmentKey) PassesPartialEqFilter(cmp *SegmentKey) bool {
	// gave nothing to filter on, consider it passing
	if cmp == nil {
		return true
	}

	if s == nil {
		return false
	}

	if cmp.Segment != nil {
		if s.Segment == nil {
			return false
		}
		if s.Segment.Value != cmp.Segment.Value {
			return false
		}
	}

	return true
}

// PassesPartialEqFilter returns whether the SegmentPolicyKey matches the passed in filter.
// On a nil comparison, we consider it a pass. Otherwise, all set (non-nil, initialized)
// fields are expected to match their "sibling" field in the comparison. Any non-matching
// value is considered a mismatch of the filter.
func (s *SegmentPolicyKey) PassesPartialEqFilter(cmp *SegmentPolicyKey) bool {
	// gave nothing to filter on, consider it passing
	if cmp == nil {
		return true
	}

	if s == nil {
		return false
	}

	if cmp.SrcSegment != nil {
		if s.SrcSegment == nil {
			return false
		}
		if s.SrcSegment.Value != cmp.SrcSegment.Value {
			return false
		}
	}

	if cmp.DstSegment != nil {
		if s.DstSegment == nil {
			return false
		}
		if s.DstSegment.Value != cmp.DstSegment.Value {
			return false
		}
	}

	return true
}

// PassesPartialEqFilter returns whether the ApplicationConfig matches the passed in filter.
// On a nil comparison, we consider it a pass. Otherwise, all set (non-nil, initialized)
// fields are expected to match their "sibling" field in the comparison. Any non-matching
// value is considered a mismatch of the filter.
func (a *ApplicationConfig) PassesPartialEqFilter(cmp *ApplicationConfig) bool {
	// if the resource is nil, there is nothing to send to the client
	if a == nil {
		return false
	}

	// gave nothing to filter on, consider it passing
	if cmp == nil {
		return true
	}

	if !a.Key.PassesPartialEqFilter(cmp.Key) {
		return false
	}

	if cmp.SrcPortStart != nil {
		if a.SrcPortStart == nil {
			return false
		}
		if a.SrcPortStart.Value != cmp.SrcPortStart.Value {
			return false
		}
	}

	if cmp.SrcPortEnd != nil {
		if a.SrcPortEnd == nil {
			return false
		}
		if a.SrcPortEnd.Value != cmp.SrcPortEnd.Value {
			return false
		}
	}

	if cmp.DstPortStart != nil {
		if a.DstPortStart == nil {
			return false
		}
		if a.DstPortStart.Value != cmp.DstPortStart.Value {
			return false
		}
	}

	if cmp.DstPortEnd != nil {
		if a.DstPortEnd == nil {
			return false
		}
		if a.DstPortEnd.Value != cmp.DstPortEnd.Value {
			return false
		}
	}

	if cmp.Protocol != nil {
		if a.Protocol == nil {
			return false
		}
		if a.Protocol.Value != cmp.Protocol.Value {
			return false
		}
	}

	return true
}

// MatchesAnyPartialEqFilter returns whether the receiver matches any filters in the given set.
func (a *ApplicationConfig) MatchesAnyPartialEqFilter(filters []*ApplicationConfig) bool {
	if len(filters) == 0 {
		return true
	}

	for _, filt := range filters {
		if a.PassesPartialEqFilter(filt) {
			return true
		}
	}

	return false
}

// PassesPartialEqFilter returns whether the DefaultActionConfig matches the passed in filter.
// On a nil comparison, we consider it a pass. Otherwise, all set (non-nil, initialized)
// fields are expected to match their "sibling" field in the comparison. Any non-matching
// value is considered a mismatch of the filter.
func (d *DefaultActionConfig) PassesPartialEqFilter(cmp *DefaultActionConfig) bool {
	// if the resource is nil, there is nothing to send to the client
	if d == nil {
		return false
	}

	// gave nothing to filter on, consider it passing
	if cmp == nil {
		return true
	}

	if !d.UnspecifiedPolicyAction.PassesPartialEqFilter(cmp.UnspecifiedPolicyAction) {
		return false
	}

	return true
}

// MatchesAnyPartialEqFilter returns whether the receiver matches any filters in the given set.
func (d *DefaultActionConfig) MatchesAnyPartialEqFilter(filters []*DefaultActionConfig) bool {
	if len(filters) == 0 {
		return true
	}

	for _, filt := range filters {
		if d.PassesPartialEqFilter(filt) {
			return true
		}
	}

	return false
}

// PassesPartialEqFilter returns whether the Domain matches the passed in filter.
// On a nil comparison, we consider it a pass. Otherwise, all set (non-nil, initialized)
// fields are expected to match their "sibling" field in the comparison. Any non-matching
// value is considered a mismatch of the filter.
func (d *Domain) PassesPartialEqFilter(cmp *Domain) bool {
	// if the resource is nil, there is nothing to send to the client
	if d == nil {
		return false
	}

	// gave nothing to filter on, consider it passing
	if cmp == nil {
		return true
	}

	if !d.Key.PassesPartialEqFilter(cmp.Key) {
		return false
	}

	if !d.SegmentPolicy.PassesPartialEqFilter(cmp.SegmentPolicy) {
		return false
	}

	return true
}

// MatchesAnyPartialEqFilter returns whether the receiver matches any filters in the given set.
func (d *Domain) MatchesAnyPartialEqFilter(filters []*Domain) bool {
	if len(filters) == 0 {
		return true
	}

	for _, filt := range filters {
		if d.PassesPartialEqFilter(filt) {
			return true
		}
	}

	return false
}

// PassesPartialEqFilter returns whether the DomainConfig matches the passed in filter.
// On a nil comparison, we consider it a pass. Otherwise, all set (non-nil, initialized)
// fields are expected to match their "sibling" field in the comparison. Any non-matching
// value is considered a mismatch of the filter.
func (d *DomainConfig) PassesPartialEqFilter(cmp *DomainConfig) bool {
	// if the resource is nil, there is nothing to send to the client
	if d == nil {
		return false
	}

	// gave nothing to filter on, consider it passing
	if cmp == nil {
		return true
	}

	if !d.Key.PassesPartialEqFilter(cmp.Key) {
		return false
	}

	if !d.IpPrefix.PassesPartialEqFilter(cmp.IpPrefix) {
		return false
	}

	if !d.Segment.PassesPartialEqFilter(cmp.Segment) {
		return false
	}

	if !d.SegmentPolicy.PassesPartialEqFilter(cmp.SegmentPolicy) {
		return false
	}

	return true
}

// MatchesAnyPartialEqFilter returns whether the receiver matches any filters in the given set.
func (d *DomainConfig) MatchesAnyPartialEqFilter(filters []*DomainConfig) bool {
	if len(filters) == 0 {
		return true
	}

	for _, filt := range filters {
		if d.PassesPartialEqFilter(filt) {
			return true
		}
	}

	return false
}

// PassesPartialEqFilter returns whether the DomainIPPrefixConfig matches the passed in filter.
// On a nil comparison, we consider it a pass. Otherwise, all set (non-nil, initialized)
// fields are expected to match their "sibling" field in the comparison. Any non-matching
// value is considered a mismatch of the filter.
func (d *DomainIPPrefixConfig) PassesPartialEqFilter(cmp *DomainIPPrefixConfig) bool {
	// if the resource is nil, there is nothing to send to the client
	if d == nil {
		return false
	}

	// gave nothing to filter on, consider it passing
	if cmp == nil {
		return true
	}

	if !d.Key.PassesPartialEqFilter(cmp.Key) {
		return false
	}

	if cmp.Segment != nil {
		if d.Segment == nil {
			return false
		}
		if d.Segment.Value != cmp.Segment.Value {
			return false
		}
	}

	return true
}

// MatchesAnyPartialEqFilter returns whether the receiver matches any filters in the given set.
func (d *DomainIPPrefixConfig) MatchesAnyPartialEqFilter(filters []*DomainIPPrefixConfig) bool {
	if len(filters) == 0 {
		return true
	}

	for _, filt := range filters {
		if d.PassesPartialEqFilter(filt) {
			return true
		}
	}

	return false
}

// PassesPartialEqFilter returns whether the DomainSegmentConfig matches the passed in filter.
// On a nil comparison, we consider it a pass. Otherwise, all set (non-nil, initialized)
// fields are expected to match their "sibling" field in the comparison. Any non-matching
// value is considered a mismatch of the filter.
func (d *DomainSegmentConfig) PassesPartialEqFilter(cmp *DomainSegmentConfig) bool {
	// if the resource is nil, there is nothing to send to the client
	if d == nil {
		return false
	}

	// gave nothing to filter on, consider it passing
	if cmp == nil {
		return true
	}

	if !d.Key.PassesPartialEqFilter(cmp.Key) {
		return false
	}

	return true
}

// MatchesAnyPartialEqFilter returns whether the receiver matches any filters in the given set.
func (d *DomainSegmentConfig) MatchesAnyPartialEqFilter(filters []*DomainSegmentConfig) bool {
	if len(filters) == 0 {
		return true
	}

	for _, filt := range filters {
		if d.PassesPartialEqFilter(filt) {
			return true
		}
	}

	return false
}

// PassesPartialEqFilter returns whether the DomainSegmentPolicy matches the passed in filter.
// On a nil comparison, we consider it a pass. Otherwise, all set (non-nil, initialized)
// fields are expected to match their "sibling" field in the comparison. Any non-matching
// value is considered a mismatch of the filter.
func (d *DomainSegmentPolicy) PassesPartialEqFilter(cmp *DomainSegmentPolicy) bool {
	// if the resource is nil, there is nothing to send to the client
	if d == nil {
		return false
	}

	// gave nothing to filter on, consider it passing
	if cmp == nil {
		return true
	}

	if !d.Key.PassesPartialEqFilter(cmp.Key) {
		return false
	}

	if !d.Counters.PassesPartialEqFilter(cmp.Counters) {
		return false
	}

	return true
}

// MatchesAnyPartialEqFilter returns whether the receiver matches any filters in the given set.
func (d *DomainSegmentPolicy) MatchesAnyPartialEqFilter(filters []*DomainSegmentPolicy) bool {
	if len(filters) == 0 {
		return true
	}

	for _, filt := range filters {
		if d.PassesPartialEqFilter(filt) {
			return true
		}
	}

	return false
}

// PassesPartialEqFilter returns whether the DomainSegmentPolicyConfig matches the passed in filter.
// On a nil comparison, we consider it a pass. Otherwise, all set (non-nil, initialized)
// fields are expected to match their "sibling" field in the comparison. Any non-matching
// value is considered a mismatch of the filter.
func (d *DomainSegmentPolicyConfig) PassesPartialEqFilter(cmp *DomainSegmentPolicyConfig) bool {
	// if the resource is nil, there is nothing to send to the client
	if d == nil {
		return false
	}

	// gave nothing to filter on, consider it passing
	if cmp == nil {
		return true
	}

	if !d.Key.PassesPartialEqFilter(cmp.Key) {
		return false
	}

	if cmp.Policy != nil {
		if d.Policy == nil {
			return false
		}
		if d.Policy.Value != cmp.Policy.Value {
			return false
		}
	}

	return true
}

// MatchesAnyPartialEqFilter returns whether the receiver matches any filters in the given set.
func (d *DomainSegmentPolicyConfig) MatchesAnyPartialEqFilter(filters []*DomainSegmentPolicyConfig) bool {
	if len(filters) == 0 {
		return true
	}

	for _, filt := range filters {
		if d.PassesPartialEqFilter(filt) {
			return true
		}
	}

	return false
}

// PassesPartialEqFilter returns whether the PolicyConfig matches the passed in filter.
// On a nil comparison, we consider it a pass. Otherwise, all set (non-nil, initialized)
// fields are expected to match their "sibling" field in the comparison. Any non-matching
// value is considered a mismatch of the filter.
func (p *PolicyConfig) PassesPartialEqFilter(cmp *PolicyConfig) bool {
	// if the resource is nil, there is nothing to send to the client
	if p == nil {
		return false
	}

	// gave nothing to filter on, consider it passing
	if cmp == nil {
		return true
	}

	if !p.Key.PassesPartialEqFilter(cmp.Key) {
		return false
	}

	if !p.ApplicationOrder.PassesPartialEqFilter(cmp.ApplicationOrder) {
		return false
	}

	if !p.ApplicationAction.PassesPartialEqFilter(cmp.ApplicationAction) {
		return false
	}

	return true
}

// MatchesAnyPartialEqFilter returns whether the receiver matches any filters in the given set.
func (p *PolicyConfig) MatchesAnyPartialEqFilter(filters []*PolicyConfig) bool {
	if len(filters) == 0 {
		return true
	}

	for _, filt := range filters {
		if p.PassesPartialEqFilter(filt) {
			return true
		}
	}

	return false
}
