// Code generated by boomtown. DO NOT EDIT.
// Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
// Arista Networks, Inc. Confidential and Proprietary.
// Subject to Arista Networks, Inc.'s EULA.
// FOR INTERNAL USE ONLY. NOT FOR DISTRIBUTION.

package hooks

import (
	"context"
	"fmt"
	"io"
	"time"

	"arista/aeris/apiserver/client"
	"arista/cvp/db"
	"arista/resources/arista/segmentation.v1"
	"arista/resources/backends/aeris"

	"github.com/aristanetworks/cloudvision-go/api/arista/subscriptions"
	"github.com/aristanetworks/cloudvision-go/api/fmp"
	"github.com/aristanetworks/goarista/key"

	rclient "arista/resources/client"
	"arista/resources/rutils/convert"
	errHandling "arista/resources/rutils/error-handling"
	stubserver "arista/resources/rutils/stubserver"

	"github.com/aristanetworks/glog"
	"go.opentelemetry.io/otel"
	"golang.org/x/sync/errgroup"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"
	"google.golang.org/protobuf/types/known/timestamppb"
	"google.golang.org/protobuf/types/known/wrapperspb"
)

type ApplicationConfigServer struct {
	Base       ApplicationConfigBase
	Reader     ApplicationConfigReader
	Subscriber aeris.Subscriber
	Writer     ApplicationConfigWriter
	segmentation.UnimplementedApplicationConfigServiceServer
}

func (a *ApplicationConfigServer) GetOne(
	ctx context.Context, req *segmentation.ApplicationConfigRequest,
) (*segmentation.ApplicationConfigResponse, error) {

	// create spans for GetOne
	ctx, span := otel.Tracer("GetOne").Start(ctx, "GetOne")
	defer span.End()

	// assert request exists
	if req == nil {
		return nil, status.Errorf(codes.InvalidArgument, "received nil request")
	}
	_, hasKeySpan := otel.Tracer("GetOne").Start(ctx, "req.HasKey")
	// assert we have a key
	if !req.HasKey() {
		hasKeySpan.End()
		return nil, status.Errorf(codes.InvalidArgument,
			"request does not contain a key, which is required for Read")
	}
	hasKeySpan.End()

	// get the Aeris path of the entity identified by the requested key
	_, pathOfSpan := otel.Tracer("GetOne").Start(ctx, "a.Reader.PathOf")
	path, keys, err := a.Reader.PathOf(ctx, req.Key)
	pathOfSpan.End()
	if err != nil {
		return nil, status.Errorf(codes.InvalidArgument, "%s", err)
	}

	// convert the request time to apiserver client opts
	_, convertReqTimeSpan := otel.Tracer("GetOne").Start(ctx, "convert-req-time")
	var opts *client.Options = nil
	if req.Time != nil {
		if err := req.Time.CheckValid(); err != nil {
			glog.Errorf("failed to parse request timestamp: %s", err)
			convertReqTimeSpan.End()
			return nil, status.Errorf(codes.InvalidArgument, "could not parse timestamp")
		}
		ts := req.Time.AsTime()
		opts = &client.Options{
			End:      ts,
			Versions: 0,
		}
	}
	convertReqTimeSpan.End()

	// call into the reader interface to issue the get
	_, getSpan := otel.Tracer("GetOne").Start(ctx, "a.Reader.Get")
	result, ts, stat := a.Reader.Get(ctx, path, keys, opts)
	getSpan.End()
	if stat != nil && stat.Code() != codes.OK {
		glog.Errorf("returning error for Get(%s): %s", path, stat.Err())
		return nil, stat.Err()
	}

	if result == nil {
		return nil, status.Errorf(codes.NotFound, "resource not found")
	}

	_, spanNewTimestamppb := otel.Tracer("GetOne").Start(ctx, "timestamppb.New")
	protoTs := timestamppb.New(ts)
	spanNewTimestamppb.End()

	return &segmentation.ApplicationConfigResponse{
		Value: result,
		Time:  protoTs,
	}, nil
}

func (a *ApplicationConfigServer) GetSome(
	req *segmentation.ApplicationConfigSomeRequest,
	stream segmentation.ApplicationConfigService_GetSomeServer,
) error {

	// assert request exists
	if req == nil {
		return status.Errorf(codes.InvalidArgument, "received nil request")
	}
	// assert we have a key
	if len(req.Keys) == 0 {
		return status.Errorf(codes.InvalidArgument,
			"request does not contain a key, which is required for Read")
	}

	// first, check if the default implementation is overridden
	override, ok := interface{}(a.Reader).(ApplicationConfigGetSomeOverride)
	if ok {
		resp := make(chan *segmentation.ApplicationConfigSomeResponse, len(req.Keys))

		var grp errgroup.Group
		grp.Go(func() error {
			return override.GetSomeOverride(stream.Context(), req, resp)
		})

		for r := range resp {
			sendErr := stream.Send(r)
			if sendErr != nil {
				glog.Errorf("failed to send on GetSome stream: %s", sendErr)
				return sendErr
			}
		}

		if err := grp.Wait(); err != nil {
			return status.Error(codes.Internal, fmt.Sprintf("failed in GetSome: %s", err))
		}
		return nil
	}

	// get the Aeris path of the entity identified by the requested key
	errCount := 0
	for _, key := range req.Keys {
		path, keys, err := a.Reader.PathOf(
			stream.Context(), key)
		if err != nil {
			errCount++
			sendErr := stream.Send(&segmentation.ApplicationConfigSomeResponse{
				Value: nil,
				Error: wrapperspb.String(status.Errorf(codes.InvalidArgument, "%s", err).Error()),
			})
			if sendErr != nil {
				glog.Errorf("failed to send on GetSome stream: %s", sendErr)
				return err
			}
			continue
		}

		// convert the request time to apiserver client opts
		var opts *client.Options = nil
		if req.Time != nil {
			if err := req.Time.CheckValid(); err != nil {
				glog.Errorf("failed to parse request timestamp: %s", err)
				return status.Errorf(codes.InvalidArgument, "could not parse timestamp")
			}
			ts := req.Time.AsTime()
			opts = &client.Options{
				End:      ts,
				Versions: 0,
			}
		}

		// call into the reader interface to issue the get
		result, ts, stat := a.Reader.Get(stream.Context(), path, keys, opts)
		if stat != nil && stat.Code() != codes.OK {
			errCount++
			sendErr := stream.Send(&segmentation.ApplicationConfigSomeResponse{
				Value: nil,
				Error: wrapperspb.String(
					fmt.Sprintf("failed to Get(%v): %s", key,
						errHandling.HandleStatus(stat))),
			})
			if sendErr != nil {
				glog.Errorf("failed to send on GetSome stream: %s", sendErr)
				return sendErr
			}
			continue
		}

		if result == nil {
			errCount++
			sendErr := stream.Send(&segmentation.ApplicationConfigSomeResponse{
				Value: nil,
				Error: wrapperspb.String(
					fmt.Sprintf("failed to Get(%v): resource not found", key)),
			})
			if sendErr != nil {
				glog.Errorf("failed to send on GetSome stream: %s", sendErr)
				return sendErr
			}
			continue
		}

		protoTs := timestamppb.New(ts)

		sendErr := stream.Send(&segmentation.ApplicationConfigSomeResponse{
			Value: result,
			Time:  protoTs,
		})
		if sendErr != nil {
			glog.Errorf("failed to send on GetSome stream: %s", sendErr)
			return sendErr
		}
	}

	if errCount > 0 {
		return status.Error(codes.Internal, fmt.Sprintf("failed to get %d items", errCount))
	}
	return nil
}

type ApplicationConfigCacheKey struct {
	Application string
}

func ApplicationConfigToCacheKey(k *segmentation.ApplicationKey,
) ApplicationConfigCacheKey {
	return ApplicationConfigCacheKey{
		Application: k.Application.Value,
	}
}

func (a *ApplicationConfigServer) GetMeta(
	ctx context.Context, req *segmentation.ApplicationConfigStreamRequest,
) (*segmentation.MetaResponse, error) {

	// create spans for GetMeta
	ctx, span := otel.Tracer("GetMeta").Start(ctx, "GetMeta")
	defer span.End()

	// assert request exists
	if req == nil {
		return nil, status.Errorf(codes.InvalidArgument, "received nil request")
	}
	glog.Info("request is not nil")

	var err error
	var opts client.Options
	_, convertReqTimeSpan := otel.Tracer("GetMeta").Start(ctx, "convert-req-time")
	if req.Time != nil {
		opts, err = convert.ToAerisTime(req.Time)
		if err != nil {
			glog.Errorf("failed to convert Aeris ClientOpts from time: %s: %s",
				req.Time.String(), err)
			convertReqTimeSpan.End()
			return nil, status.Errorf(codes.Internal, "could not format time-arguments")
		}
	}
	convertReqTimeSpan.End()

	// call into the reader interface to issue the get
	getAllCtx, getSpan := otel.Tracer("GetMeta").Start(ctx, "a.GetAll")
	results := make(chan ApplicationConfigAndTs, 3)
	var grp errgroup.Group
	grp.Go(func() error {
		_, childspan_go := otel.Tracer("GetMeta").Start(getAllCtx, "a.Reader.GetAll")
		stat := a.Reader.GetAll(ctx, req, &opts, results)
		childspan_go.End()
		if stat != nil && stat.Code() != codes.OK {
			glog.Errorf("received error in GetAll, cancelling request: %s", stat.Err())
			return stat.Err()
		}
		return nil
	})
	getSpan.End()

	count := uint32(0)
	var lastTime time.Time
	for r := range results {
		// filter this result if needed
		if !r.Value.MatchesAnyPartialEqFilter(req.PartialEqFilter) {
			continue
		}
		if r.Time.After(lastTime) {
			lastTime = r.Time
		}
		count = count + 1
	}

	protoTs := timestamppb.New(lastTime)

	return &segmentation.MetaResponse{
		Time:  protoTs,
		Type:  subscriptions.Operation_INITIAL,
		Count: &wrapperspb.UInt32Value{Value: count},
	}, nil
}

func (a *ApplicationConfigServer) SubscribeMeta(
	req *segmentation.ApplicationConfigStreamRequest,
	stream segmentation.ApplicationConfigService_SubscribeMetaServer,
) error {
	// create spans for SubscribeMeta
	ctx, span := otel.Tracer("SubscribeMeta").Start(stream.Context(), "SubscribeMeta")
	defer span.End()

	// assert request exists
	if req == nil {
		return status.Errorf(codes.InvalidArgument, "received nil request")
	}

	// check request validity
	_, childspan := otel.Tracer("SubscribeMeta").Start(ctx, "a.Reader.ValidateSubscribe")
	stat := a.Reader.ValidateSubscribe(ctx, req)
	childspan.End()
	if stat != nil && stat.Code() != codes.OK {
		glog.Errorf("failing list operation: %s", stat.Err())
		return stat.Err()
	}
	serverStream := stubserver.NewStubbedServer[segmentation.ApplicationConfigStreamResponse](ctx, 5)

	// make error group
	var grp errgroup.Group
	grp.Go(func() error {
		_, childspan_go := otel.Tracer("SubscribeMeta").Start(ctx, "Subscribe")
		err := a.Subscribe(req, &serverStream)
		childspan_go.End()
		if err != nil {
			glog.Errorf("received error in Subscribe, cancelling request: %s", err)
		}
		return nil
	})

	// 1. build a cache of keys until INITIAL_SYNC_COMPLETE
	// 1a. Send metadata at INITIAL_SYNC_COMPLETE
	// 2. on delete, and on update iff update is not an existing key:
	//   a. update cache of keys
	//   b. send updated metadata to stream
	resourceKeys := make(map[ApplicationConfigCacheKey]struct{})
	_, streamSpan := otel.Tracer("SubscribeMeta").Start(ctx, "SubscribeStream")
	var lastTime *timestamppb.Timestamp
	var lastCount int
	glog.Infof("request time: %v", req.Time)
	for {
		item, err := serverStream.Recv()
		if err == io.EOF {
			break
		}
		if err != nil {
			glog.Errorf("encountered an error while reading from Subscribe: %s", err)
			streamSpan.End()
			return status.Errorf(codes.Internal,
				"encountered an error while reading from Subscribe")
		}
		switch item.Type {
		case subscriptions.Operation_INITIAL_SYNC_COMPLETE:
			count := len(resourceKeys)
			lastCount = count
			err = stream.Send(&segmentation.MetaResponse{
				Time:  lastTime,
				Type:  subscriptions.Operation_INITIAL,
				Count: &wrapperspb.UInt32Value{Value: uint32(count)},
			})
			if err != nil {
				glog.Errorf("send on stream failed: %s", err)
				streamSpan.End()
				return status.Errorf(codes.Internal, "send on stream failed")
			}
			err = stream.Send(&segmentation.MetaResponse{
				Type: subscriptions.Operation_INITIAL_SYNC_COMPLETE,
			})
			if err != nil {
				glog.Errorf("send on stream failed: %s", err)
				streamSpan.End()
				return status.Errorf(codes.Internal, "send on stream failed")
			}
		case subscriptions.Operation_INITIAL:
			if req.Time == nil || req.Time.Start.AsTime().Before(item.Time.AsTime()) {
				resourceKeys[ApplicationConfigToCacheKey(item.Value.Key)] = struct{}{}
				lastTime = item.Time
			}
		case subscriptions.Operation_DELETED:
			if item.Value.Key == nil {
				// If the key of a DELETED operation is nil, it's a delete all.
				resourceKeys = make(map[ApplicationConfigCacheKey]struct{})
			} else {
				delete(resourceKeys, ApplicationConfigToCacheKey(item.Value.Key))
			}
			count := len(resourceKeys)
			if count != lastCount {
				lastCount = count
				err = stream.Send(&segmentation.MetaResponse{
					Time:  item.Time,
					Type:  subscriptions.Operation_UPDATED,
					Count: &wrapperspb.UInt32Value{Value: uint32(count)},
				})
				if err != nil {
					glog.Errorf("send on stream failed: %s", err)
					streamSpan.End()
					return status.Errorf(codes.Internal, "send on stream failed")
				}
			}
		case subscriptions.Operation_UPDATED:
			if _, ok := resourceKeys[ApplicationConfigToCacheKey(item.Value.Key)]; !ok {
				resourceKeys[ApplicationConfigToCacheKey(item.Value.Key)] = struct{}{}
				count := len(resourceKeys)
				if count != lastCount {
					lastCount = count
					err = stream.Send(&segmentation.MetaResponse{
						Time:  item.Time,
						Type:  subscriptions.Operation_UPDATED,
						Count: &wrapperspb.UInt32Value{Value: uint32(count)},
					})
					if err != nil {
						glog.Errorf("send on stream failed: %s", err)
						streamSpan.End()
						return status.Errorf(codes.Internal, "send on stream failed")
					}
				}
			}
		default:
			streamSpan.End()
			return status.Errorf(codes.Internal, "unrecognized operation: %s", item.Type)
		}
	}

	err := grp.Wait()
	streamSpan.End()
	if err != nil {
		glog.Errorf("ending stream due to error: %s", err)
		return err
	}
	return nil
}

func (a *ApplicationConfigServer) GetAll(
	req *segmentation.ApplicationConfigStreamRequest,
	stream segmentation.ApplicationConfigService_GetAllServer,
) error {
	// create spans for GetAll
	ctx, span := otel.Tracer("GetAll").Start(stream.Context(), "GetAll")
	defer span.End()

	// assert request exists
	if req == nil {
		return status.Errorf(codes.InvalidArgument, "received nil request")
	}

	// assert we allow GetAll of this resource
	_, childspan := otel.Tracer("GetAll").Start(ctx, "a.Reader.AllowGetAll")
	if c := a.Reader.AllowGetAll(ctx); c != codes.OK {
		childspan.End()
		return status.Errorf(c, "GetAll of ApplicationConfig is not allowed")
	}
	childspan.End()

	var err error
	var opts client.Options
	_, childspan = otel.Tracer("GetAll").Start(ctx, "convert.ToAerisTime(req.Time)")
	if req.Time != nil {
		opts, err = convert.ToAerisTime(req.Time)
		if err != nil {
			glog.Errorf("failed to convert Aeris ClientOpts from time: %s: %s",
				req.Time.String(), err)
			childspan.End()
			return status.Errorf(codes.Internal, "could not format time-arguments")
		}
	}
	childspan.End()

	// spawn the Reader GetAll method in an errgroup so we can reliably
	// (and synchronously) get the error after the channel closes
	results := make(chan ApplicationConfigAndTs, 3)
	var grp errgroup.Group
	grp.Go(func() error {
		_, childspan_go := otel.Tracer("GetAll").Start(ctx, "a.Reader.GetAll")
		stat := a.Reader.GetAll(ctx, req, &opts, results)
		childspan_go.End()
		if stat != nil && stat.Code() != codes.OK {
			glog.Errorf("received error in GetAll, cancelling request: %s", stat.Err())
			return stat.Err()
		}
		return nil
	})

	_, childspan = otel.Tracer("GetAll").Start(ctx, "filtering")

	for r := range results {
		// filter this result if needed
		if !r.Value.MatchesAnyPartialEqFilter(req.PartialEqFilter) {
			continue
		}

		ts := timestamppb.New(r.Time)

		// send to the client
		err = stream.Send(&segmentation.ApplicationConfigStreamResponse{
			Value: r.Value,
			Time:  ts,
			Type:  subscriptions.Operation_INITIAL,
		})
		if err != nil {
			childspan.End()
			if errHandling.IsCanceled(err) {
				glog.Error("send on stream canceled due to context cancelation")
				return status.Errorf(codes.Canceled, "send on stream canceled")
			} else {
				errCode := errHandling.GetProperGrpcStatus(err)
				glog.Errorf("send on stream failed: %v", err)
				return status.Errorf(errCode, "error sending on stream")
			}
		}
	}

	childspan.End()

	_, childspan = otel.Tracer("GetAll").Start(ctx, "grp.Wait")
	err = grp.Wait()
	childspan.End()
	if err != nil {
		glog.Errorf("ending stream due to error: %s", err)
		return err // this will be a status type from GetAll
	}

	return nil
}

func (a *ApplicationConfigServer) Subscribe(
	req *segmentation.ApplicationConfigStreamRequest,
	stream segmentation.ApplicationConfigService_SubscribeServer,
) error {
	return a.Reader.Subscribe(stream.Context(), req, stream)
}

func (a *ApplicationConfigServer) Set(
	ctx context.Context, req *segmentation.ApplicationConfigSetRequest,
) (*segmentation.ApplicationConfigSetResponse, error) {

	// create spans for Set
	ctx, span := otel.Tracer("Set").Start(ctx, "Set")
	defer span.End()

	// assert request exists
	if req == nil {
		return nil, status.Errorf(codes.InvalidArgument, "received nil request")
	}
	// assert we have a key
	_, hasKeySpan := otel.Tracer("Set").Start(ctx, "req.HasKey")
	if !req.HasKey() {
		hasKeySpan.End()
		return nil, status.Errorf(codes.InvalidArgument,
			"request does not contain a key, which is required for Set")
	}
	hasKeySpan.End()

	// ask the writer to validate the request's model
	_, validateWriteSpan := otel.Tracer("Set").Start(ctx, "a.Writer.ValidateWrite")
	err := a.Writer.ValidateWrite(ctx, req.Value)
	if err != nil {
		glog.Errorf("received invalid write: %s", err)
		validateWriteSpan.End()
		return nil, status.Errorf(codes.InvalidArgument, "%s", err)
	}
	validateWriteSpan.End()

	// call into the writer interface to issue the write
	_, writeSpan := otel.Tracer("Set").Start(ctx, "a.Writer.Write")
	ts, stat := a.Writer.Write(ctx, req.Value)
	if stat != nil && stat.Code() != codes.OK {
		c, ok := interface{}(req.Value).(rclient.Censorable)
		if ok {
			c.Censor()
		}
		glog.Errorf("returning error for Write(%s): %s",
			req.Value, stat.Err())
		writeSpan.End()
		return nil, stat.Err()
	}
	writeSpan.End()

	protoTs := timestamppb.New(ts)

	return &segmentation.ApplicationConfigSetResponse{
		Value: req.Value,
		Time:  protoTs,
	}, nil
}

func (a *ApplicationConfigServer) SetSome(
	req *segmentation.ApplicationConfigSetSomeRequest,
	stream segmentation.ApplicationConfigService_SetSomeServer,
) error {
	if req == nil {
		return status.Error(codes.InvalidArgument, "request is null")
	}
	if len(req.Values) == 0 {
		return status.Error(codes.InvalidArgument, "request contains no values")
	}

	// first, check if the default implementation is overridden
	override, ok := interface{}(a.Writer).(ApplicationConfigSetSomeOverride)
	if ok {
		errs := override.SetSomeOverride(stream.Context(), req)
		for _, e := range errs {
			sendErr := stream.Send(&segmentation.ApplicationConfigSetSomeResponse{
				Key:   e.Key,
				Error: e.Error.Error(),
			})
			if sendErr != nil {
				glog.Errorf("failed to send on SetSome stream: %s", sendErr)
				return sendErr
			}
		}

		if len(errs) > 0 {
			return status.Error(codes.Internal, fmt.Sprintf("failed to write %d items", len(errs)))
		}
		return nil
	}

	// alternatively, validate and Write(...) the inputs
	errCount := 0
	for _, value := range req.Values {
		// first, validate the input
		err := a.Writer.ValidateWrite(stream.Context(), value)
		if err != nil {
			errCount++
			sendErr := stream.Send(&segmentation.ApplicationConfigSetSomeResponse{
				Key:   value.Key,
				Error: fmt.Sprintf("failed validation: %s", err),
			})
			if sendErr != nil {
				glog.Errorf("failed to send on SetSome stream: %s", sendErr)
				return err
			}
			continue
		}

		// then, write the value
		_, writeErr := a.Writer.Write(stream.Context(), value)
		if writeErr != nil {
			sendErr := stream.Send(&segmentation.ApplicationConfigSetSomeResponse{
				Key:   value.Key,
				Error: fmt.Sprintf("failed to write: %s", writeErr),
			})
			if sendErr != nil {
				glog.Errorf("failed to send on SetSome stream: %s", sendErr)
				return sendErr
			}
		}
	}

	if errCount > 0 {
		return status.Error(codes.Internal, fmt.Sprintf("failed to write %d items", errCount))
	}
	return nil
}

func (a *ApplicationConfigServer) Delete(
	ctx context.Context, req *segmentation.ApplicationConfigDeleteRequest,
) (*segmentation.ApplicationConfigDeleteResponse, error) {

	// create span for Delete
	ctx, span := otel.Tracer("Delete").Start(ctx, "Delete")
	defer span.End()

	// assert request exists
	if req == nil {
		return nil, status.Errorf(codes.InvalidArgument, "received nil request")
	}
	// assert we have a key
	_, childspan := otel.Tracer("Delete").Start(ctx, "req.HasKey")
	if !req.HasKey() {
		childspan.End()
		return nil, status.Errorf(codes.InvalidArgument,
			"request does not contain a key, which is required for Delete")
	}
	childspan.End()

	// call into the writer interface to issue the deletion
	_, childspan = otel.Tracer("Delete").Start(ctx, "a.Writer.Delete")
	ts, stat := a.Writer.Delete(ctx, req.Key)
	childspan.End()
	if stat != nil && stat.Code() != codes.OK {
		glog.Errorf("returning error for Delete(%s): %s",
			req.Key, stat.Err())
		return nil, stat.Err()
	}

	_, childspan = otel.Tracer("Delete").Start(ctx, "timestamppb.New")
	protoTs := timestamppb.New(ts)
	childspan.End()

	return &segmentation.ApplicationConfigDeleteResponse{
		Key:  req.Key,
		Time: protoTs,
	}, nil
}

func (a *ApplicationConfigServer) DeleteSome(
	req *segmentation.ApplicationConfigDeleteSomeRequest,
	stream segmentation.ApplicationConfigService_DeleteSomeServer,
) error {

	// assert request exists
	if req == nil {
		return status.Errorf(codes.InvalidArgument, "received nil request")
	}
	// assert we have a key
	if len(req.Keys) == 0 {
		return status.Errorf(codes.InvalidArgument,
			"request does not contain a key, which is required for Delete")
	}

	// first, check if the default implementation is overriden
	override, ok := interface{}(a.Writer).(ApplicationConfigDeleteSomeOverride)
	if ok {
		errs := override.DeleteSomeOverride(stream.Context(), req)
		for _, e := range errs {
			sendErr := stream.Send(&segmentation.ApplicationConfigDeleteSomeResponse{
				Key:   e.Key,
				Error: e.Error.Error(),
			})
			if sendErr != nil {
				glog.Errorf("failed to send on DeleteSome stream: %s", sendErr)
			}
		}

		if len(errs) > 0 {
			return status.Error(codes.Internal, fmt.Sprintf("failed to write %d items", len(errs)))
		}
		return nil
	}

	// call into the writer interface to issue the deletion
	errCount := 0
	for _, key := range req.Keys {
		_, stat := a.Writer.Delete(stream.Context(), key)
		if stat != nil && stat.Code() != codes.OK {
			errCount++
			sendErr := stream.Send(&segmentation.ApplicationConfigDeleteSomeResponse{
				Key: key,
				Error: fmt.Sprintf("failed to delete(%s): %s",
					key, stat.Err()),
			})
			if sendErr != nil {
				glog.Errorf("failed to send on DeleteSome stream: %s", sendErr)
				return sendErr
			}
		}
	}

	if errCount > 0 {
		return status.Error(codes.Internal, fmt.Sprintf("failed to delete %d items", errCount))
	}

	return nil
}

func (a *ApplicationConfigServer) DeleteAll(
	req *segmentation.ApplicationConfigDeleteAllRequest,
	stream segmentation.ApplicationConfigService_DeleteAllServer,
) error {
	// create spans for DeleteAll
	ctx, span := otel.Tracer("DeleteAll").Start(stream.Context(), "DeleteAll")
	defer span.End()

	switch deleter := a.Writer.(type) {
	case ApplicationConfigAllDeleter:
		results := make(chan DeletedApplicationConfigAndTs, 5)
		var grp errgroup.Group
		grp.Go(func() error {
			_, childspan_go := otel.Tracer("DeleteAll").Start(ctx, "deleter.DeleteAllHandler")
			defer childspan_go.End()
			defer close(results)
			stat := deleter.DeleteAllHandler(ctx, req, results)
			if stat != nil && stat.Code() != codes.OK {
				glog.Errorf("DeleteAll failure: %s", stat.Err())
				return status.Errorf(codes.Internal, "failure in DeleteAll: %s", stat.Err())
			}
			return nil
		})
		_, childspan := otel.Tracer("DeleteAll").Start(ctx, "stream.Send(&segmentation.ApplicationConfigDeleteAllResponse)")
		for res := range results {
			err := stream.Send(&segmentation.ApplicationConfigDeleteAllResponse{
				Type:  res.TypeAndError.Type,
				Error: &wrapperspb.StringValue{Value: (res.TypeAndError.Errorf())},
				Key:   res.Key,
				Time:  timestamppb.New(res.Time),
			})
			if err != nil {
				glog.Errorf("failed to send DeleteAllResponse on stream, err: %s", err)
				childspan.End()
				return status.Errorf(codes.Internal,
					"failed to send DeleteAllResponse on stream")
			}
		}
		childspan.End()
		_, childspan = otel.Tracer("DeleteAll").Start(ctx, "grp.Wait")
		err := grp.Wait()
		childspan.End()
		if err != nil {
			glog.Errorf("ending stream due to error: %s", err)
			return status.Errorf(codes.Internal, "failed to send DeleteAllResponse on stream")
		}
	case ApplicationConfigPathDeleter:
		childctx, childspan := otel.Tracer("DeleteAll").Start(ctx, "deleter.GetDeletePaths")
		paths, ds, errGet := deleter.GetDeletePaths(childctx)
		childspan.End()
		if errGet != nil {
			glog.Errorf("error in GetDeletePaths: %s", errGet)
			return status.Errorf(codes.Internal, "failure in DeleteAll: %s", errGet)
		}
		_, childspan = otel.Tracer("DeleteAll").Start(ctx, "db.DeletePath")
		for _, pth := range paths {
			conn := a.Base.Connection()
			err := db.DeletePath(ctx, pth, &ds, conn,
				func(deleteKeys []key.Key, path key.Path, errDelete error, now time.Time) error {
					return ApplicationConfigDeleteAllResponseHandler(a,
						stream, deleteKeys, path, errDelete, now)
				})
			if err != nil {
				glog.Errorf("failure in DeletePath path: %s, err: %s", pth, err)
				childspan.End()
				return status.Errorf(codes.Internal,
					"failure in DeleteAll: failed to delete path: %s, err: %s", pth, err)
			}
		}
		childspan.End()
	default:
		_, childspan := otel.Tracer("DeleteAll").Start(ctx, "a.Reader.AllowGetAll")
		if c := a.Reader.AllowGetAll(ctx); c != codes.OK {
			glog.Errorf("GetAll of ApplicationConfig is not allowed")
			childspan.End()
			return status.Errorf(codes.Internal, "DeleteAll failure")
		}
		childspan.End()
		results := make(chan ApplicationConfigAndTs, 5)
		var opts client.Options
		var grp errgroup.Group
		grp.Go(func() error {
			_, childspan_go := otel.Tracer("DeleteAll").Start(ctx, "a.Reader.GetAll")
			defer childspan_go.End()
			stat := a.Reader.GetAll(ctx, &segmentation.ApplicationConfigStreamRequest{}, &opts, results)
			if stat != nil && stat.Code() != codes.OK {
				glog.Errorf("received error in GetAll, cancelling request: %s", stat.Err())
				return status.Errorf(codes.Internal, "DeleteAll failure for ApplicationConfig")
			}
			return nil
		})
		_, childspan = otel.Tracer("DeleteAll").Start(ctx, "a.Writer.Delete")
		for res := range results {
			ts, stat := a.Writer.Delete(ctx, res.Value.Key)
			if stat != nil && stat.Code() != codes.OK {
				deleteType := fmp.DeleteError_DELETE_ERROR_INTERNAL
				if stat.Code() == codes.PermissionDenied || stat.Code() == codes.Unauthenticated {
					deleteType = fmp.DeleteError_DELETE_ERROR_UNAUTHORIZED
				}
				err := stream.Send(&segmentation.ApplicationConfigDeleteAllResponse{
					Type:  deleteType,
					Error: &wrapperspb.StringValue{Value: (stat.String())},
					Key:   res.Value.Key,
					Time:  timestamppb.New(ts),
				})
				if err != nil {
					glog.Errorf("failed to send DeleteAllResponse on stream, err: %s", err)
					childspan.End()
					return status.Errorf(codes.Internal, "stream send error for DeleteAll: %s", err)
				}
			}
		}
		childspan.End()
		_, childspan = otel.Tracer("DeleteAll").Start(ctx, "grp.Wait")
		err := grp.Wait()
		childspan.End()
		if err != nil {
			glog.Errorf("ending stream due to error: %s", err)
			return status.Errorf(codes.Internal,
				"failed to send DeleteAllResponse on stream: %s", err)
		}
	}
	return nil
}

func ApplicationConfigDeleteAllResponseHandler(a *ApplicationConfigServer,
	stream segmentation.ApplicationConfigService_DeleteAllServer, deleteKeys []key.Key, path key.Path,
	errDelete error, now time.Time) error {
	ctx := stream.Context()

	deleteType := fmp.DeleteError_DELETE_ERROR_INTERNAL
	if st, ok := status.FromError(errDelete); ok &&
		(st.Code() == codes.PermissionDenied ||
			st.Code() == codes.Unauthenticated) {
		deleteType = fmp.DeleteError_DELETE_ERROR_UNAUTHORIZED
	}
	for _, deleteKey := range deleteKeys {
		returnKey, er := a.Reader.KeyOf(ctx, path, deleteKey)
		if er != nil {
			glog.Errorf("failed to retrieve key: %s of path: %s, err: %s", deleteKey, path, er)
			return fmt.Errorf("failed to retrieve key: %s for path: %s, %s",
				deleteKey, path, er)
		}

		er = stream.Send(&segmentation.ApplicationConfigDeleteAllResponse{
			Type:  deleteType,
			Error: &wrapperspb.StringValue{Value: (errDelete.Error())},
			Key:   returnKey,
			Time:  timestamppb.New(now),
		})
		if er != nil {
			glog.Errorf("failed to send DeleteAllResponse on stream, err: %s", er)
			return status.Errorf(codes.Internal,
				"failed to send DeleteAllResponse on stream")
		}
	}
	return nil
}
