// Code generated by boomtown. DO NOT EDIT.
// Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
// Arista Networks, Inc. Confidential and Proprietary.
// Subject to Arista Networks, Inc.'s EULA.
// FOR INTERNAL USE ONLY. NOT FOR DISTRIBUTION.

package hooks

import (
	"context"

	"arista/aeris/apiserver/client"
	"arista/resources/arista/segmentation.v1"
	"arista/resources/backends/aeris"

	"github.com/aristanetworks/cloudvision-go/api/arista/subscriptions"

	rclient "arista/resources/client"
	"arista/resources/rutils/convert"
	errHandling "arista/resources/rutils/error-handling"

	"github.com/aristanetworks/glog"
	"go.opentelemetry.io/otel"
	"golang.org/x/sync/errgroup"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"
	"google.golang.org/protobuf/types/known/timestamppb"
)

type DefaultActionConfigServer struct {
	Base       DefaultActionConfigBase
	Reader     DefaultActionConfigReader
	Subscriber aeris.Subscriber
	Writer     DefaultActionConfigWriter
	segmentation.UnimplementedDefaultActionConfigServiceServer
}

func (d *DefaultActionConfigServer) GetOne(
	ctx context.Context, req *segmentation.DefaultActionConfigRequest,
) (*segmentation.DefaultActionConfigResponse, error) {

	// create spans for GetOne
	ctx, span := otel.Tracer("GetOne").Start(ctx, "GetOne")
	defer span.End()

	// assert request exists
	if req == nil {
		return nil, status.Errorf(codes.InvalidArgument, "received nil request")
	}

	// get the Aeris path of the entity identified by the requested key
	_, pathOfSpan := otel.Tracer("GetOne").Start(ctx, "d.Reader.PathOf")
	path, keys, err := d.Reader.PathOf(ctx)
	pathOfSpan.End()
	if err != nil {
		return nil, status.Errorf(codes.InvalidArgument, "%s", err)
	}

	// convert the request time to apiserver client opts
	_, convertReqTimeSpan := otel.Tracer("GetOne").Start(ctx, "convert-req-time")
	var opts *client.Options = nil
	if req.Time != nil {
		if err := req.Time.CheckValid(); err != nil {
			glog.Errorf("failed to parse request timestamp: %s", err)
			convertReqTimeSpan.End()
			return nil, status.Errorf(codes.InvalidArgument, "could not parse timestamp")
		}
		ts := req.Time.AsTime()
		opts = &client.Options{
			End:      ts,
			Versions: 0,
		}
	}
	convertReqTimeSpan.End()

	// call into the reader interface to issue the get
	_, getSpan := otel.Tracer("GetOne").Start(ctx, "d.Reader.Get")
	result, ts, stat := d.Reader.Get(ctx, path, keys, opts)
	getSpan.End()
	if stat != nil && stat.Code() != codes.OK {
		glog.Errorf("returning error for Get(%s): %s", path, stat.Err())
		return nil, stat.Err()
	}

	if result == nil {
		return nil, status.Errorf(codes.NotFound, "resource not found")
	}

	_, spanNewTimestamppb := otel.Tracer("GetOne").Start(ctx, "timestamppb.New")
	protoTs := timestamppb.New(ts)
	spanNewTimestamppb.End()

	return &segmentation.DefaultActionConfigResponse{
		Value: result,
		Time:  protoTs,
	}, nil
}

func (d *DefaultActionConfigServer) GetAll(
	req *segmentation.DefaultActionConfigStreamRequest,
	stream segmentation.DefaultActionConfigService_GetAllServer,
) error {
	// create spans for GetAll
	ctx, span := otel.Tracer("GetAll").Start(stream.Context(), "GetAll")
	defer span.End()

	// assert request exists
	if req == nil {
		return status.Errorf(codes.InvalidArgument, "received nil request")
	}

	// assert we allow GetAll of this resource
	_, childspan := otel.Tracer("GetAll").Start(ctx, "d.Reader.AllowGetAll")
	if c := d.Reader.AllowGetAll(ctx); c != codes.OK {
		childspan.End()
		return status.Errorf(c, "GetAll of DefaultActionConfig is not allowed")
	}
	childspan.End()

	var err error
	var opts client.Options
	_, childspan = otel.Tracer("GetAll").Start(ctx, "convert.ToAerisTime(req.Time)")
	if req.Time != nil {
		opts, err = convert.ToAerisTime(req.Time)
		if err != nil {
			glog.Errorf("failed to convert Aeris ClientOpts from time: %s: %s",
				req.Time.String(), err)
			childspan.End()
			return status.Errorf(codes.Internal, "could not format time-arguments")
		}
	}
	childspan.End()

	// spawn the Reader GetAll method in an errgroup so we can reliably
	// (and synchronously) get the error after the channel closes
	results := make(chan DefaultActionConfigAndTs, 3)
	var grp errgroup.Group
	grp.Go(func() error {
		_, childspan_go := otel.Tracer("GetAll").Start(ctx, "d.Reader.GetAll")
		stat := d.Reader.GetAll(ctx, req, &opts, results)
		childspan_go.End()
		if stat != nil && stat.Code() != codes.OK {
			glog.Errorf("received error in GetAll, cancelling request: %s", stat.Err())
			return stat.Err()
		}
		return nil
	})

	_, childspan = otel.Tracer("GetAll").Start(ctx, "filtering")

	for r := range results {
		// filter this result if needed
		if !r.Value.MatchesAnyPartialEqFilter(req.PartialEqFilter) {
			continue
		}

		ts := timestamppb.New(r.Time)

		// send to the client
		err = stream.Send(&segmentation.DefaultActionConfigStreamResponse{
			Value: r.Value,
			Time:  ts,
			Type:  subscriptions.Operation_INITIAL,
		})
		if err != nil {
			childspan.End()
			if errHandling.IsCanceled(err) {
				glog.Error("send on stream canceled due to context cancelation")
				return status.Errorf(codes.Canceled, "send on stream canceled")
			} else {
				errCode := errHandling.GetProperGrpcStatus(err)
				glog.Errorf("send on stream failed: %v", err)
				return status.Errorf(errCode, "error sending on stream")
			}
		}
	}

	childspan.End()

	_, childspan = otel.Tracer("GetAll").Start(ctx, "grp.Wait")
	err = grp.Wait()
	childspan.End()
	if err != nil {
		glog.Errorf("ending stream due to error: %s", err)
		return err // this will be a status type from GetAll
	}

	return nil
}

func (d *DefaultActionConfigServer) Subscribe(
	req *segmentation.DefaultActionConfigStreamRequest,
	stream segmentation.DefaultActionConfigService_SubscribeServer,
) error {
	return d.Reader.Subscribe(stream.Context(), req, stream)
}

func (d *DefaultActionConfigServer) Set(
	ctx context.Context, req *segmentation.DefaultActionConfigSetRequest,
) (*segmentation.DefaultActionConfigSetResponse, error) {

	// create spans for Set
	ctx, span := otel.Tracer("Set").Start(ctx, "Set")
	defer span.End()

	// assert request exists
	if req == nil {
		return nil, status.Errorf(codes.InvalidArgument, "received nil request")
	}

	// ask the writer to validate the request's model
	_, validateWriteSpan := otel.Tracer("Set").Start(ctx, "d.Writer.ValidateWrite")
	err := d.Writer.ValidateWrite(ctx, req.Value)
	if err != nil {
		glog.Errorf("received invalid write: %s", err)
		validateWriteSpan.End()
		return nil, status.Errorf(codes.InvalidArgument, "%s", err)
	}
	validateWriteSpan.End()

	// call into the writer interface to issue the write
	_, writeSpan := otel.Tracer("Set").Start(ctx, "d.Writer.Write")
	ts, stat := d.Writer.Write(ctx, req.Value)
	if stat != nil && stat.Code() != codes.OK {
		c, ok := interface{}(req.Value).(rclient.Censorable)
		if ok {
			c.Censor()
		}
		glog.Errorf("returning error for Write(%s): %s",
			req.Value, stat.Err())
		writeSpan.End()
		return nil, stat.Err()
	}
	writeSpan.End()

	protoTs := timestamppb.New(ts)

	return &segmentation.DefaultActionConfigSetResponse{
		Value: req.Value,
		Time:  protoTs,
	}, nil
}
