// Code generated by boomtown. DO NOT EDIT.
// Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
// Arista Networks, Inc. Confidential and Proprietary.
// Subject to Arista Networks, Inc.'s EULA.
// FOR INTERNAL USE ONLY. NOT FOR DISTRIBUTION.

package hooks

import (
	"context"
	"fmt"
	"io"
	"time"

	"arista/aeris/apiserver/client"
	"arista/resources/arista/segmentation.v1"
	"arista/resources/backends/aeris"

	"github.com/aristanetworks/cloudvision-go/api/arista/subscriptions"

	"arista/resources/rutils/convert"
	errHandling "arista/resources/rutils/error-handling"
	stubserver "arista/resources/rutils/stubserver"

	"github.com/aristanetworks/glog"
	"go.opentelemetry.io/otel"
	"golang.org/x/sync/errgroup"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"
	"google.golang.org/protobuf/types/known/timestamppb"
	"google.golang.org/protobuf/types/known/wrapperspb"
)

type DomainSegmentPolicyServer struct {
	Base       DomainSegmentPolicyBase
	Reader     DomainSegmentPolicyReader
	Subscriber aeris.Subscriber
	segmentation.UnimplementedDomainSegmentPolicyServiceServer
}

func (d *DomainSegmentPolicyServer) GetOne(
	ctx context.Context, req *segmentation.DomainSegmentPolicyRequest,
) (*segmentation.DomainSegmentPolicyResponse, error) {

	// create spans for GetOne
	ctx, span := otel.Tracer("GetOne").Start(ctx, "GetOne")
	defer span.End()

	// assert request exists
	if req == nil {
		return nil, status.Errorf(codes.InvalidArgument, "received nil request")
	}
	_, hasKeySpan := otel.Tracer("GetOne").Start(ctx, "req.HasKey")
	// assert we have a key
	if !req.HasKey() {
		hasKeySpan.End()
		return nil, status.Errorf(codes.InvalidArgument,
			"request does not contain a key, which is required for Read")
	}
	hasKeySpan.End()

	// get the Aeris path of the entity identified by the requested key
	_, pathOfSpan := otel.Tracer("GetOne").Start(ctx, "d.Reader.PathOf")
	path, keys, err := d.Reader.PathOf(ctx, req.Key)
	pathOfSpan.End()
	if err != nil {
		return nil, status.Errorf(codes.InvalidArgument, "%s", err)
	}

	// convert the request time to apiserver client opts
	_, convertReqTimeSpan := otel.Tracer("GetOne").Start(ctx, "convert-req-time")
	var opts *client.Options = nil
	if req.Time != nil {
		if err := req.Time.CheckValid(); err != nil {
			glog.Errorf("failed to parse request timestamp: %s", err)
			convertReqTimeSpan.End()
			return nil, status.Errorf(codes.InvalidArgument, "could not parse timestamp")
		}
		ts := req.Time.AsTime()
		opts = &client.Options{
			End:      ts,
			Versions: 0,
		}
	}
	convertReqTimeSpan.End()

	// call into the reader interface to issue the get
	_, getSpan := otel.Tracer("GetOne").Start(ctx, "d.Reader.Get")
	result, ts, stat := d.Reader.Get(ctx, path, keys, opts)
	getSpan.End()
	if stat != nil && stat.Code() != codes.OK {
		glog.Errorf("returning error for Get(%s): %s", path, stat.Err())
		return nil, stat.Err()
	}

	if result == nil {
		return nil, status.Errorf(codes.NotFound, "resource not found")
	}

	_, spanNewTimestamppb := otel.Tracer("GetOne").Start(ctx, "timestamppb.New")
	protoTs := timestamppb.New(ts)
	spanNewTimestamppb.End()

	return &segmentation.DomainSegmentPolicyResponse{
		Value: result,
		Time:  protoTs,
	}, nil
}

func (d *DomainSegmentPolicyServer) GetSome(
	req *segmentation.DomainSegmentPolicySomeRequest,
	stream segmentation.DomainSegmentPolicyService_GetSomeServer,
) error {

	// assert request exists
	if req == nil {
		return status.Errorf(codes.InvalidArgument, "received nil request")
	}
	// assert we have a key
	if len(req.Keys) == 0 {
		return status.Errorf(codes.InvalidArgument,
			"request does not contain a key, which is required for Read")
	}

	// first, check if the default implementation is overridden
	override, ok := interface{}(d.Reader).(DomainSegmentPolicyGetSomeOverride)
	if ok {
		resp := make(chan *segmentation.DomainSegmentPolicySomeResponse, len(req.Keys))

		var grp errgroup.Group
		grp.Go(func() error {
			return override.GetSomeOverride(stream.Context(), req, resp)
		})

		for r := range resp {
			sendErr := stream.Send(r)
			if sendErr != nil {
				glog.Errorf("failed to send on GetSome stream: %s", sendErr)
				return sendErr
			}
		}

		if err := grp.Wait(); err != nil {
			return status.Error(codes.Internal, fmt.Sprintf("failed in GetSome: %s", err))
		}
		return nil
	}

	// get the Aeris path of the entity identified by the requested key
	errCount := 0
	for _, key := range req.Keys {
		path, keys, err := d.Reader.PathOf(
			stream.Context(), key)
		if err != nil {
			errCount++
			sendErr := stream.Send(&segmentation.DomainSegmentPolicySomeResponse{
				Value: nil,
				Error: wrapperspb.String(status.Errorf(codes.InvalidArgument, "%s", err).Error()),
			})
			if sendErr != nil {
				glog.Errorf("failed to send on GetSome stream: %s", sendErr)
				return err
			}
			continue
		}

		// convert the request time to apiserver client opts
		var opts *client.Options = nil
		if req.Time != nil {
			if err := req.Time.CheckValid(); err != nil {
				glog.Errorf("failed to parse request timestamp: %s", err)
				return status.Errorf(codes.InvalidArgument, "could not parse timestamp")
			}
			ts := req.Time.AsTime()
			opts = &client.Options{
				End:      ts,
				Versions: 0,
			}
		}

		// call into the reader interface to issue the get
		result, ts, stat := d.Reader.Get(stream.Context(), path, keys, opts)
		if stat != nil && stat.Code() != codes.OK {
			errCount++
			sendErr := stream.Send(&segmentation.DomainSegmentPolicySomeResponse{
				Value: nil,
				Error: wrapperspb.String(
					fmt.Sprintf("failed to Get(%v): %s", key,
						errHandling.HandleStatus(stat))),
			})
			if sendErr != nil {
				glog.Errorf("failed to send on GetSome stream: %s", sendErr)
				return sendErr
			}
			continue
		}

		if result == nil {
			errCount++
			sendErr := stream.Send(&segmentation.DomainSegmentPolicySomeResponse{
				Value: nil,
				Error: wrapperspb.String(
					fmt.Sprintf("failed to Get(%v): resource not found", key)),
			})
			if sendErr != nil {
				glog.Errorf("failed to send on GetSome stream: %s", sendErr)
				return sendErr
			}
			continue
		}

		protoTs := timestamppb.New(ts)

		sendErr := stream.Send(&segmentation.DomainSegmentPolicySomeResponse{
			Value: result,
			Time:  protoTs,
		})
		if sendErr != nil {
			glog.Errorf("failed to send on GetSome stream: %s", sendErr)
			return sendErr
		}
	}

	if errCount > 0 {
		return status.Error(codes.Internal, fmt.Sprintf("failed to get %d items", errCount))
	}
	return nil
}

type DomainSegmentPolicyCacheKey struct {
	Domain     string
	DstSegment string
	SrcSegment string
	Vrf        string
}

func DomainSegmentPolicyToCacheKey(k *segmentation.DomainSegmentPolicyKey,
) DomainSegmentPolicyCacheKey {
	return DomainSegmentPolicyCacheKey{
		Domain:     k.Domain.Value,
		DstSegment: k.DstSegment.Value,
		SrcSegment: k.SrcSegment.Value,
		Vrf:        k.Vrf.Value,
	}
}

func (d *DomainSegmentPolicyServer) GetMeta(
	ctx context.Context, req *segmentation.DomainSegmentPolicyStreamRequest,
) (*segmentation.MetaResponse, error) {

	// create spans for GetMeta
	ctx, span := otel.Tracer("GetMeta").Start(ctx, "GetMeta")
	defer span.End()

	// assert request exists
	if req == nil {
		return nil, status.Errorf(codes.InvalidArgument, "received nil request")
	}
	glog.Info("request is not nil")

	var err error
	var opts client.Options
	_, convertReqTimeSpan := otel.Tracer("GetMeta").Start(ctx, "convert-req-time")
	if req.Time != nil {
		opts, err = convert.ToAerisTime(req.Time)
		if err != nil {
			glog.Errorf("failed to convert Aeris ClientOpts from time: %s: %s",
				req.Time.String(), err)
			convertReqTimeSpan.End()
			return nil, status.Errorf(codes.Internal, "could not format time-arguments")
		}
	}
	convertReqTimeSpan.End()

	// call into the reader interface to issue the get
	getAllCtx, getSpan := otel.Tracer("GetMeta").Start(ctx, "d.GetAll")
	results := make(chan DomainSegmentPolicyAndTs, 3)
	var grp errgroup.Group
	grp.Go(func() error {
		_, childspan_go := otel.Tracer("GetMeta").Start(getAllCtx, "d.Reader.GetAll")
		stat := d.Reader.GetAll(ctx, req, &opts, results)
		childspan_go.End()
		if stat != nil && stat.Code() != codes.OK {
			glog.Errorf("received error in GetAll, cancelling request: %s", stat.Err())
			return stat.Err()
		}
		return nil
	})
	getSpan.End()

	count := uint32(0)
	var lastTime time.Time
	for r := range results {
		// filter this result if needed
		if !r.Value.MatchesAnyPartialEqFilter(req.PartialEqFilter) {
			continue
		}
		if r.Time.After(lastTime) {
			lastTime = r.Time
		}
		count = count + 1
	}

	protoTs := timestamppb.New(lastTime)

	return &segmentation.MetaResponse{
		Time:  protoTs,
		Type:  subscriptions.Operation_INITIAL,
		Count: &wrapperspb.UInt32Value{Value: count},
	}, nil
}

func (d *DomainSegmentPolicyServer) SubscribeMeta(
	req *segmentation.DomainSegmentPolicyStreamRequest,
	stream segmentation.DomainSegmentPolicyService_SubscribeMetaServer,
) error {
	// create spans for SubscribeMeta
	ctx, span := otel.Tracer("SubscribeMeta").Start(stream.Context(), "SubscribeMeta")
	defer span.End()

	// assert request exists
	if req == nil {
		return status.Errorf(codes.InvalidArgument, "received nil request")
	}

	// check request validity
	_, childspan := otel.Tracer("SubscribeMeta").Start(ctx, "d.Reader.ValidateSubscribe")
	stat := d.Reader.ValidateSubscribe(ctx, req)
	childspan.End()
	if stat != nil && stat.Code() != codes.OK {
		glog.Errorf("failing list operation: %s", stat.Err())
		return stat.Err()
	}
	serverStream := stubserver.NewStubbedServer[segmentation.DomainSegmentPolicyStreamResponse](ctx, 5)

	// make error group
	var grp errgroup.Group
	grp.Go(func() error {
		_, childspan_go := otel.Tracer("SubscribeMeta").Start(ctx, "Subscribe")
		err := d.Subscribe(req, &serverStream)
		childspan_go.End()
		if err != nil {
			glog.Errorf("received error in Subscribe, cancelling request: %s", err)
		}
		return nil
	})

	// 1. build a cache of keys until INITIAL_SYNC_COMPLETE
	// 1a. Send metadata at INITIAL_SYNC_COMPLETE
	// 2. on delete, and on update iff update is not an existing key:
	//   a. update cache of keys
	//   b. send updated metadata to stream
	resourceKeys := make(map[DomainSegmentPolicyCacheKey]struct{})
	_, streamSpan := otel.Tracer("SubscribeMeta").Start(ctx, "SubscribeStream")
	var lastTime *timestamppb.Timestamp
	var lastCount int
	glog.Infof("request time: %v", req.Time)
	for {
		item, err := serverStream.Recv()
		if err == io.EOF {
			break
		}
		if err != nil {
			glog.Errorf("encountered an error while reading from Subscribe: %s", err)
			streamSpan.End()
			return status.Errorf(codes.Internal,
				"encountered an error while reading from Subscribe")
		}
		switch item.Type {
		case subscriptions.Operation_INITIAL_SYNC_COMPLETE:
			count := len(resourceKeys)
			lastCount = count
			err = stream.Send(&segmentation.MetaResponse{
				Time:  lastTime,
				Type:  subscriptions.Operation_INITIAL,
				Count: &wrapperspb.UInt32Value{Value: uint32(count)},
			})
			if err != nil {
				glog.Errorf("send on stream failed: %s", err)
				streamSpan.End()
				return status.Errorf(codes.Internal, "send on stream failed")
			}
			err = stream.Send(&segmentation.MetaResponse{
				Type: subscriptions.Operation_INITIAL_SYNC_COMPLETE,
			})
			if err != nil {
				glog.Errorf("send on stream failed: %s", err)
				streamSpan.End()
				return status.Errorf(codes.Internal, "send on stream failed")
			}
		case subscriptions.Operation_INITIAL:
			if req.Time == nil || req.Time.Start.AsTime().Before(item.Time.AsTime()) {
				resourceKeys[DomainSegmentPolicyToCacheKey(item.Value.Key)] = struct{}{}
				lastTime = item.Time
			}
		case subscriptions.Operation_DELETED:
			if item.Value.Key == nil {
				// If the key of a DELETED operation is nil, it's a delete all.
				resourceKeys = make(map[DomainSegmentPolicyCacheKey]struct{})
			} else {
				delete(resourceKeys, DomainSegmentPolicyToCacheKey(item.Value.Key))
			}
			count := len(resourceKeys)
			if count != lastCount {
				lastCount = count
				err = stream.Send(&segmentation.MetaResponse{
					Time:  item.Time,
					Type:  subscriptions.Operation_UPDATED,
					Count: &wrapperspb.UInt32Value{Value: uint32(count)},
				})
				if err != nil {
					glog.Errorf("send on stream failed: %s", err)
					streamSpan.End()
					return status.Errorf(codes.Internal, "send on stream failed")
				}
			}
		case subscriptions.Operation_UPDATED:
			if _, ok := resourceKeys[DomainSegmentPolicyToCacheKey(item.Value.Key)]; !ok {
				resourceKeys[DomainSegmentPolicyToCacheKey(item.Value.Key)] = struct{}{}
				count := len(resourceKeys)
				if count != lastCount {
					lastCount = count
					err = stream.Send(&segmentation.MetaResponse{
						Time:  item.Time,
						Type:  subscriptions.Operation_UPDATED,
						Count: &wrapperspb.UInt32Value{Value: uint32(count)},
					})
					if err != nil {
						glog.Errorf("send on stream failed: %s", err)
						streamSpan.End()
						return status.Errorf(codes.Internal, "send on stream failed")
					}
				}
			}
		default:
			streamSpan.End()
			return status.Errorf(codes.Internal, "unrecognized operation: %s", item.Type)
		}
	}

	err := grp.Wait()
	streamSpan.End()
	if err != nil {
		glog.Errorf("ending stream due to error: %s", err)
		return err
	}
	return nil
}

func (d *DomainSegmentPolicyServer) GetAll(
	req *segmentation.DomainSegmentPolicyStreamRequest,
	stream segmentation.DomainSegmentPolicyService_GetAllServer,
) error {
	// create spans for GetAll
	ctx, span := otel.Tracer("GetAll").Start(stream.Context(), "GetAll")
	defer span.End()

	// assert request exists
	if req == nil {
		return status.Errorf(codes.InvalidArgument, "received nil request")
	}

	// assert we allow GetAll of this resource
	_, childspan := otel.Tracer("GetAll").Start(ctx, "d.Reader.AllowGetAll")
	if c := d.Reader.AllowGetAll(ctx); c != codes.OK {
		childspan.End()
		return status.Errorf(c, "GetAll of DomainSegmentPolicy is not allowed")
	}
	childspan.End()

	var err error
	var opts client.Options
	_, childspan = otel.Tracer("GetAll").Start(ctx, "convert.ToAerisTime(req.Time)")
	if req.Time != nil {
		opts, err = convert.ToAerisTime(req.Time)
		if err != nil {
			glog.Errorf("failed to convert Aeris ClientOpts from time: %s: %s",
				req.Time.String(), err)
			childspan.End()
			return status.Errorf(codes.Internal, "could not format time-arguments")
		}
	}
	childspan.End()

	// spawn the Reader GetAll method in an errgroup so we can reliably
	// (and synchronously) get the error after the channel closes
	results := make(chan DomainSegmentPolicyAndTs, 3)
	var grp errgroup.Group
	grp.Go(func() error {
		_, childspan_go := otel.Tracer("GetAll").Start(ctx, "d.Reader.GetAll")
		stat := d.Reader.GetAll(ctx, req, &opts, results)
		childspan_go.End()
		if stat != nil && stat.Code() != codes.OK {
			glog.Errorf("received error in GetAll, cancelling request: %s", stat.Err())
			return stat.Err()
		}
		return nil
	})

	_, childspan = otel.Tracer("GetAll").Start(ctx, "filtering")

	for r := range results {
		// filter this result if needed
		if !r.Value.MatchesAnyPartialEqFilter(req.PartialEqFilter) {
			continue
		}

		ts := timestamppb.New(r.Time)

		// send to the client
		err = stream.Send(&segmentation.DomainSegmentPolicyStreamResponse{
			Value: r.Value,
			Time:  ts,
			Type:  subscriptions.Operation_INITIAL,
		})
		if err != nil {
			childspan.End()
			if errHandling.IsCanceled(err) {
				glog.Error("send on stream canceled due to context cancelation")
				return status.Errorf(codes.Canceled, "send on stream canceled")
			} else {
				errCode := errHandling.GetProperGrpcStatus(err)
				glog.Errorf("send on stream failed: %v", err)
				return status.Errorf(errCode, "error sending on stream")
			}
		}
	}

	childspan.End()

	_, childspan = otel.Tracer("GetAll").Start(ctx, "grp.Wait")
	err = grp.Wait()
	childspan.End()
	if err != nil {
		glog.Errorf("ending stream due to error: %s", err)
		return err // this will be a status type from GetAll
	}

	return nil
}

func (d *DomainSegmentPolicyServer) Subscribe(
	req *segmentation.DomainSegmentPolicyStreamRequest,
	stream segmentation.DomainSegmentPolicyService_SubscribeServer,
) error {
	return d.Reader.Subscribe(stream.Context(), req, stream)
}
